/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.strategy;

import com.aizuda.snailjob.common.core.exception.SnailJobCommonException;
import com.aizuda.snailjob.common.core.util.CronExpression;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.enums.DelayLevelEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.google.common.base.Preconditions;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class WaitStrategies {
    private WaitStrategies() {
    }

    public static WaitStrategy delayLevelWait() {
        return new DelayLevelWaitStrategy();
    }

    public static WaitStrategy fixedWait() {
        return new FixedWaitStrategy();
    }

    public static WaitStrategy cronWait() {
        return new CronWaitStrategy();
    }

    public static WaitStrategy randomWait(long minimumTime, TimeUnit minimumTimeUnit, long maximumTime, TimeUnit maximumTimeUnit) {
        return new RandomWaitStrategy(minimumTimeUnit.toMillis(minimumTime), maximumTimeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy randomWait() {
        return new RandomWaitStrategy();
    }

    private static final class DelayLevelWaitStrategy
    implements WaitStrategy {
        private DelayLevelWaitStrategy() {
        }

        @Override
        public Long computeTriggerTime(WaitStrategyContext context) {
            DelayLevelEnum levelEnum = DelayLevelEnum.getDelayLevelByLevel(context.getDelayLevel());
            Duration of = Duration.of(levelEnum.getTime(), levelEnum.getUnit());
            return context.getNextTriggerAt() + of.toMillis();
        }
    }

    private static final class FixedWaitStrategy
    implements WaitStrategy {
        private FixedWaitStrategy() {
        }

        @Override
        public Long computeTriggerTime(WaitStrategyContext retryContext) {
            return retryContext.getNextTriggerAt() + DateUtils.toEpochMilli(Integer.parseInt(retryContext.getTriggerInterval()));
        }
    }

    private static final class CronWaitStrategy
    implements WaitStrategy {
        private CronWaitStrategy() {
        }

        @Override
        public Long computeTriggerTime(WaitStrategyContext context) {
            try {
                Date nextValidTime = new CronExpression(context.getTriggerInterval()).getNextValidTimeAfter(new Date(context.getNextTriggerAt()));
                return DateUtils.toEpochMilli(nextValidTime);
            }
            catch (ParseException e) {
                throw new SnailJobServerException("\u89e3\u6790CRON\u8868\u8fbe\u5f0f\u5f02\u5e38 [{}]", context.getTriggerInterval(), e);
            }
        }
    }

    private static final class RandomWaitStrategy
    implements WaitStrategy {
        private static final Random RANDOM = new Random();
        private final long minimum;
        private long maximum;

        public RandomWaitStrategy(long minimum, long maximum) {
            Preconditions.checkArgument((minimum >= 0L ? 1 : 0) != 0, (String)"minimum must be >= 0 but is %d", (long)minimum);
            Preconditions.checkArgument((maximum > minimum ? 1 : 0) != 0, (String)"maximum must be > minimum but maximum is %d and minimum is", (long)maximum, (long)minimum);
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public RandomWaitStrategy() {
            this.minimum = 0L;
        }

        @Override
        public Long computeTriggerTime(WaitStrategyContext retryContext) {
            if (Objects.nonNull(retryContext) && this.maximum == 0L) {
                this.maximum = Long.parseLong(retryContext.getTriggerInterval());
            }
            Preconditions.checkArgument((this.maximum > this.minimum ? 1 : 0) != 0, (String)"maximum must be > minimum but maximum is %d and minimum is", (long)this.maximum, (long)this.minimum);
            long t = Math.abs(RANDOM.nextLong()) % (this.maximum - this.minimum);
            return t + this.minimum + DateUtils.toNowMilli();
        }
    }

    public static enum WaitStrategyEnum {
        DELAY_LEVEL(1, WaitStrategies.delayLevelWait()),
        FIXED(2, WaitStrategies.fixedWait()),
        CRON(3, WaitStrategies.cronWait()),
        RANDOM(4, WaitStrategies.randomWait());

        private final int type;
        private final WaitStrategy waitStrategy;

        public static WaitStrategy getWaitStrategy(int backOff) {
            return WaitStrategyEnum.getWaitStrategyEnum(backOff).getWaitStrategy();
        }

        public static WaitStrategyEnum getWaitStrategyEnum(int type) {
            for (WaitStrategyEnum value : WaitStrategyEnum.values()) {
                if (value.type != type) continue;
                return value;
            }
            throw new SnailJobCommonException("\u7b49\u5f85\u7b56\u7565\u7c7b\u578b\u4e0d\u5b58\u5728. [{}]", (Object)type);
        }

        private WaitStrategyEnum(int type, WaitStrategy waitStrategy) {
            this.type = type;
            this.waitStrategy = waitStrategy;
        }

        public int getType() {
            return this.type;
        }

        public WaitStrategy getWaitStrategy() {
            return this.waitStrategy;
        }
    }

    public static class WaitStrategyContext {
        private String triggerInterval;
        private long nextTriggerAt;
        private Integer delayLevel;

        public void setNextTriggerAt(long nextTriggerAt) {
            this.nextTriggerAt = nextTriggerAt;
        }

        public void setNextTriggerAt(LocalDateTime nextTriggerAt) {
            this.nextTriggerAt = DateUtils.toEpochMilli(nextTriggerAt);
        }

        public String getTriggerInterval() {
            return this.triggerInterval;
        }

        public long getNextTriggerAt() {
            return this.nextTriggerAt;
        }

        public Integer getDelayLevel() {
            return this.delayLevel;
        }

        public void setTriggerInterval(String triggerInterval) {
            this.triggerInterval = triggerInterval;
        }

        public void setDelayLevel(Integer delayLevel) {
            this.delayLevel = delayLevel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WaitStrategyContext)) {
                return false;
            }
            WaitStrategyContext other = (WaitStrategyContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNextTriggerAt() != other.getNextTriggerAt()) {
                return false;
            }
            Integer this$delayLevel = this.getDelayLevel();
            Integer other$delayLevel = other.getDelayLevel();
            if (this$delayLevel == null ? other$delayLevel != null : !((Object)this$delayLevel).equals(other$delayLevel)) {
                return false;
            }
            String this$triggerInterval = this.getTriggerInterval();
            String other$triggerInterval = other.getTriggerInterval();
            return !(this$triggerInterval == null ? other$triggerInterval != null : !this$triggerInterval.equals(other$triggerInterval));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WaitStrategyContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $nextTriggerAt = this.getNextTriggerAt();
            result = result * 59 + (int)($nextTriggerAt >>> 32 ^ $nextTriggerAt);
            Integer $delayLevel = this.getDelayLevel();
            result = result * 59 + ($delayLevel == null ? 43 : ((Object)$delayLevel).hashCode());
            String $triggerInterval = this.getTriggerInterval();
            result = result * 59 + ($triggerInterval == null ? 43 : $triggerInterval.hashCode());
            return result;
        }

        public String toString() {
            return "WaitStrategies.WaitStrategyContext(triggerInterval=" + this.getTriggerInterval() + ", nextTriggerAt=" + this.getNextTriggerAt() + ", delayLevel=" + this.getDelayLevel() + ")";
        }
    }
}

