/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.allocate.client;

import com.aizuda.snailjob.server.common.ClientLoadBalance;
import com.aizuda.snailjob.server.common.allocate.client.ClientLoadBalanceManager;
import com.aizuda.snailjob.server.common.allocate.common.ConsistentHashRouter;
import com.aizuda.snailjob.server.common.allocate.common.Node;
import java.util.ArrayList;
import java.util.TreeSet;

public class ClientLoadBalanceConsistentHash
implements ClientLoadBalance {
    private final int virtualNodeCnt;

    public ClientLoadBalanceConsistentHash(int virtualNodeCnt) {
        this.virtualNodeCnt = virtualNodeCnt;
    }

    @Override
    public String route(String allocKey, TreeSet<String> clientAllAddressSet) {
        ArrayList<ClientNode> cidNodes = new ArrayList<ClientNode>();
        for (String clientAddress : clientAllAddressSet) {
            cidNodes.add(new ClientNode(clientAddress));
        }
        ConsistentHashRouter consistentHashRouter = new ConsistentHashRouter(cidNodes, this.virtualNodeCnt);
        ClientNode clientNode = (ClientNode)consistentHashRouter.routeNode(allocKey);
        return clientNode.clientAddress;
    }

    @Override
    public int routeType() {
        return ClientLoadBalanceManager.AllocationAlgorithmEnum.CONSISTENT_HASH.getType();
    }

    private static class ClientNode
    implements Node {
        private final String clientAddress;

        public ClientNode(String clientAddress) {
            this.clientAddress = clientAddress;
        }

        @Override
        public String getKey() {
            return this.clientAddress;
        }
    }
}

