/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.rpc.client;

import com.aizuda.snailjob.common.core.model.NettyResult;
import com.aizuda.snailjob.common.core.rpc.RpcContext;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.rpc.client.NettyChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClientHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClientHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        FullHttpResponse response = msg;
        String content = response.content().toString(CharsetUtil.UTF_8);
        HttpHeaders headers = response.headers();
        SnailJobLog.LOCAL.info("Receive server data content:[{}], headers:[{}]", new Object[]{content, headers});
        NettyResult nettyResult = (NettyResult)JsonUtil.parseObject((String)content, NettyResult.class);
        RpcContext.invoke((Long)nettyResult.getRequestId(), (NettyResult)nettyResult, (boolean)false);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        SnailJobLog.LOCAL.debug("channelRegistered", new Object[0]);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        SnailJobLog.LOCAL.debug("channelUnregistered", new Object[0]);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        SnailJobLog.LOCAL.debug("channelActive", new Object[0]);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        SnailJobLog.LOCAL.debug("channelInactive", new Object[0]);
        NettyChannel.removeChannel(ctx.channel());
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        super.channelReadComplete(ctx);
        SnailJobLog.LOCAL.debug("channelReadComplete", new Object[0]);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
        SnailJobLog.LOCAL.debug("channelWritabilityChanged", new Object[0]);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SnailJobLog.LOCAL.error("snail-job netty-http client exception", new Object[]{cause});
        super.exceptionCaught(ctx, cause);
        NettyChannel.removeChannel(ctx.channel());
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        NettyChannel.removeChannel(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        SnailJobLog.LOCAL.debug("userEventTriggered", new Object[0]);
    }
}

