/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.cache;

import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.lock.LockManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class CacheLockRecord
implements Lifecycle {
    private static Cache<String, String> CACHE;

    public static void addLockRecord(String lockName) {
        CACHE.put((Object)lockName, (Object)lockName);
    }

    public static boolean lockRecordRecentlyCreated(String lockName) {
        return CACHE.asMap().containsKey(lockName);
    }

    public static long getSize() {
        return CACHE.size();
    }

    public static void remove(String lockName) {
        CACHE.invalidate((Object)lockName);
        LockManager.clear();
    }

    public static void clear() {
        CACHE.invalidateAll();
    }

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("CacheLockRecord start", new Object[0]);
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterWrite(Duration.ofHours(1L)).build();
    }

    @Override
    public void close() {
        CACHE.invalidateAll();
    }
}

