/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.alarm;

import com.aizuda.snailjob.common.core.alarm.Alarm;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.AlarmInfoConverter;
import com.aizuda.snailjob.server.common.Lifecycle;
import com.aizuda.snailjob.server.common.cache.CacheNotifyRateLimiter;
import com.aizuda.snailjob.server.common.dto.AlarmInfo;
import com.aizuda.snailjob.server.common.dto.NotifyConfigInfo;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.triple.ImmutableTriple;
import com.aizuda.snailjob.server.common.triple.Triple;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.NotifyRecipientMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.NotifyRecipient;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.RateLimiter;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.CollectionUtils;

public abstract class AbstractAlarm<E extends ApplicationEvent, A extends AlarmInfo>
implements Runnable,
Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(AbstractAlarm.class);
    @Autowired
    @Qualifier(value="alarmExecutorService")
    protected TaskScheduler taskScheduler;
    @Autowired
    protected AccessTemplate accessTemplate;
    @Autowired
    protected NotifyRecipientMapper recipientMapper;

    @Override
    public void run() {
        try {
            List<A> alarmInfos = this.poll();
            if (CollectionUtils.isEmpty(alarmInfos)) {
                return;
            }
            HashSet<String> namespaceIds = new HashSet<String>();
            HashSet<String> groupNames = new HashSet<String>();
            HashSet<String> businessIds = new HashSet<String>();
            Map<Triple<String, String, String>, List<A>> waitSendAlarmInfos = this.convertAlarmDTO(alarmInfos, namespaceIds, groupNames, businessIds);
            Map<Triple<String, String, String>, List<NotifyConfigInfo>> notifyConfig = this.obtainNotifyConfig(namespaceIds, groupNames, businessIds);
            waitSendAlarmInfos.forEach((key, list) -> {
                List notifyConfigsList = notifyConfig.getOrDefault(key, Lists.newArrayList());
                for (AlarmInfo alarmDTO : list) {
                    this.sendAlarm(notifyConfigsList, alarmDTO);
                }
            });
        }
        catch (InterruptedException e) {
            SnailJobLog.LOCAL.info("retry task fail dead letter alarm stop", new Object[0]);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("RetryTaskFailDeadLetterAlarmListener queue poll Exception", new Object[]{e});
        }
    }

    protected Map<Triple<String, String, String>, List<NotifyConfigInfo>> obtainNotifyConfig(Set<String> namespaceIds, Set<String> groupNames, Set<String> businessIds) {
        List notifyConfigs = this.accessTemplate.getNotifyConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getNotifyStatus, (Object)StatusEnum.YES.getStatus())).in(NotifyConfig::getSystemTaskType, (Collection)StreamUtils.toList(this.getSystemTaskType(), SyetemTaskTypeEnum::getType))).eq(NotifyConfig::getNotifyScene, (Object)this.getNotifyScene())).in(NotifyConfig::getNamespaceId, namespaceIds)).in(NotifyConfig::getGroupName, groupNames)).in(NotifyConfig::getBusinessId, businessIds));
        if (CollectionUtils.isEmpty((Collection)notifyConfigs)) {
            return Maps.newHashMap();
        }
        Set recipientIds = notifyConfigs.stream().flatMap(config -> JsonUtil.parseList((String)config.getRecipientIds(), Long.class).stream()).collect(Collectors.toSet());
        List notifyRecipients = this.recipientMapper.selectBatchIds(recipientIds);
        Map recipientMap = StreamUtils.toIdentityMap((Collection)notifyRecipients, NotifyRecipient::getId);
        if (CollectionUtils.isEmpty(recipientIds)) {
            return Maps.newHashMap();
        }
        List<NotifyConfigInfo> notifyConfigInfos = AlarmInfoConverter.INSTANCE.retryToNotifyConfigInfos(notifyConfigs);
        return StreamUtils.groupByKey(notifyConfigInfos, configInfo -> {
            List recipients = StreamUtils.toList(configInfo.getRecipientIds(), recipientId -> {
                NotifyRecipient notifyRecipient = (NotifyRecipient)recipientMap.get(recipientId);
                if (Objects.isNull(notifyRecipient)) {
                    return null;
                }
                NotifyConfigInfo.RecipientInfo notifyConfigInfo = new NotifyConfigInfo.RecipientInfo();
                notifyConfigInfo.setNotifyAttribute(notifyRecipient.getNotifyAttribute());
                notifyConfigInfo.setNotifyType(notifyRecipient.getNotifyType());
                return notifyConfigInfo;
            });
            configInfo.setRecipientInfos(recipients);
            return ImmutableTriple.of(configInfo.getNamespaceId(), configInfo.getGroupName(), configInfo.getBusinessId());
        });
    }

    protected abstract List<SyetemTaskTypeEnum> getSystemTaskType();

    protected abstract Map<Triple<String, String, String>, List<A>> convertAlarmDTO(List<A> var1, Set<String> var2, Set<String> var3, Set<String> var4);

    protected abstract List<A> poll() throws InterruptedException;

    protected abstract AlarmContext buildAlarmContext(A var1, NotifyConfigInfo var2);

    @Override
    public void start() {
        this.startLog();
        this.taskScheduler.scheduleAtFixedRate((Runnable)this, Duration.parse("PT1S"));
    }

    protected abstract void startLog();

    @Override
    public void close() {
    }

    protected void sendAlarm(List<NotifyConfigInfo> notifyConfigsList, A alarmDTO) {
        for (NotifyConfigInfo notifyConfig : notifyConfigsList) {
            RateLimiter rateLimiter;
            if (Objects.equals(notifyConfig.getRateLimiterStatus(), StatusEnum.YES.getStatus()) && Objects.nonNull(rateLimiter = this.getRateLimiter(String.valueOf(notifyConfig.getId()), notifyConfig.getRateLimiterThreshold().intValue())) && !rateLimiter.tryAcquire(1L, TimeUnit.SECONDS) || Objects.nonNull(((AlarmInfo)alarmDTO).getCount()) && Objects.nonNull(notifyConfig.getNotifyThreshold()) && notifyConfig.getNotifyThreshold() >= ((AlarmInfo)alarmDTO).getCount()) continue;
            for (NotifyConfigInfo.RecipientInfo recipientInfo : notifyConfig.getRecipientInfos()) {
                if (Objects.isNull(recipientInfo)) continue;
                AlarmContext context = this.buildAlarmContext(alarmDTO, notifyConfig);
                context.setNotifyAttribute(recipientInfo.getNotifyAttribute());
                Alarm alarm = SnailJobAlarmFactory.getAlarmType((Integer)recipientInfo.getNotifyType());
                alarm.asyncSendMessage((Object)context);
            }
        }
    }

    protected RateLimiter getRateLimiter(String key, double rateLimiterThreshold) {
        RateLimiter rateLimiter = CacheNotifyRateLimiter.getRateLimiterByKey(key);
        if (Objects.isNull(rateLimiter) || rateLimiter.getRate() != rateLimiterThreshold) {
            CacheNotifyRateLimiter.put(key, RateLimiter.create((double)rateLimiterThreshold));
        }
        return rateLimiter;
    }

    protected abstract int getNotifyScene();

    protected abstract void doOnApplicationEvent(E var1);
}

