/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.log.factory;

import com.aizuda.snailjob.common.log.factory.LogFactory;
import java.util.Objects;
import org.springframework.core.env.Environment;

public class GlobalLogFactory {
    private static volatile LogFactory currentLogFactory;
    private static final Object lock;
    private static Environment environment;

    public static void setEnvironment(Environment environment) {
        GlobalLogFactory.environment = environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory get() {
        if (null == currentLogFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentLogFactory) {
                    currentLogFactory = LogFactory.create();
                }
            }
        }
        return currentLogFactory;
    }

    public static LogFactory set(Class<? extends LogFactory> logFactoryClass) {
        try {
            return GlobalLogFactory.set(logFactoryClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static LogFactory set(LogFactory logFactory) {
        logFactory.getLog(GlobalLogFactory.class).debug((Boolean)false, "Custom Use [{}] Logger.", logFactory.name, new Object[0]);
        currentLogFactory = logFactory;
        return currentLogFactory;
    }

    public static Boolean logSwitch() {
        if (Objects.nonNull(environment)) {
            return (Boolean)environment.getProperty("snail-job.log.status", Boolean.class, (Object)Boolean.TRUE);
        }
        return Boolean.TRUE;
    }

    static {
        lock = new Object();
    }
}

