/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.util;

import com.aizuda.snailjob.common.core.exception.SnailJobInnerExecutorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class SnailJobFileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadFile(String urlString, File destinationFile, int connectionTimeout, int readTimeout) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(readTimeout);
        try (BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
             FileOutputStream fileOS = new FileOutputStream(destinationFile);
             BufferedOutputStream bufferedOutStream = new BufferedOutputStream(fileOS);){
            int bytesRead;
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = ((InputStream)inputStream).read(dataBuffer, 0, 1024)) != -1) {
                bufferedOutStream.write(dataBuffer, 0, bytesRead);
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static File mkdirs(File directory) throws SnailJobInnerExecutorException {
        if (directory != null && !directory.mkdirs() && !directory.isDirectory()) {
            throw new SnailJobInnerExecutorException("Cannot create directory '" + String.valueOf(directory) + "'.");
        }
        return directory;
    }
}

