/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.starter;

import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.job.core.annotation.JobExecutor;
import com.aizuda.snailjob.common.core.util.SnailJobNetworkUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Configuration
@Role(value=2)
@ComponentScan(value={"com.aizuda.snailjob.client.job.core.*", "com.aizuda.snailjob.client.common.*"})
@ConditionalOnClass(value={JobExecutor.class})
@ConditionalOnProperty(prefix="snail-job", name={"enabled"}, havingValue="true")
public class SnailJobClientJobCoreAutoConfiguration {
    private static final String SNAIL_JOB_CLIENT_HOST = "snail-job.host";

    @Bean
    public Object configureSnailJobHost(SnailJobNetworkUtils networkUtils, SnailJobProperties snailJobProperties) {
        String host = snailJobProperties.getHost();
        if (StrUtil.isBlank((CharSequence)host) && StrUtil.isNotBlank((CharSequence)(host = System.getProperty(SNAIL_JOB_CLIENT_HOST)))) {
            snailJobProperties.setHost(host);
        }
        if (StrUtil.isBlank((CharSequence)host)) {
            host = networkUtils.findPreferredHostAddress();
            snailJobProperties.setHost(host);
            System.setProperty(SNAIL_JOB_CLIENT_HOST, host);
        }
        SnailJobLog.LOCAL.info("Snail-Job \u5ba2\u6237\u7aefIP\u4e3a: {}", new Object[]{host});
        return null;
    }
}

