/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.job.core.MapHandler;
import com.aizuda.snailjob.client.job.core.client.JobNettyClient;
import com.aizuda.snailjob.client.job.core.executor.JobContextManager;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.exception.SnailJobMapReduceException;
import com.aizuda.snailjob.common.core.model.JobContext;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.dto.ExecuteResult;
import com.aizuda.snailjob.model.request.MapTaskRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.CollectionUtils;

public final class MapInvokeHandler
implements InvocationHandler {
    private static final JobNettyClient CLIENT = (JobNettyClient)RequestBuilder.newBuilder().client(JobNettyClient.class).async(Boolean.FALSE.booleanValue()).build();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!MapHandler.class.getDeclaredMethod("doMap", List.class, String.class).equals(method)) {
            return method.invoke((Object)this, args);
        }
        return this.doMap((List)args[0], (String)args[1]);
    }

    public ExecuteResult doMap(List<Object> taskList, String nextTaskName) {
        if (StrUtil.isBlank((CharSequence)nextTaskName)) {
            throw new SnailJobMapReduceException("The next task name can not blank or null {}", (Object)nextTaskName);
        }
        if (CollectionUtils.isEmpty(taskList)) {
            throw new SnailJobMapReduceException("The task list can not empty {}", (Object)nextTaskName);
        }
        if (taskList.size() > 200) {
            SnailJobLog.LOCAL.warn("[{}] map task size is too large, network maybe overload... please try to split the tasks.", new Object[]{nextTaskName});
        }
        if (taskList.size() > 500) {
            throw new SnailJobMapReduceException("[{}] map task size is too large, network maybe overload... please try to split the tasks.", (Object)nextTaskName);
        }
        if ("ROOT_MAP".equals(nextTaskName)) {
            throw new SnailJobMapReduceException("The Next taskName can not be {}", (Object)"ROOT_MAP");
        }
        JobContext jobContext = JobContextManager.getJobContext();
        Assert.notNull((Object)jobContext, () -> new SnailJobMapReduceException("job context is null"));
        MapTaskRequest mapTaskRequest = new MapTaskRequest();
        mapTaskRequest.setJobId(jobContext.getJobId());
        mapTaskRequest.setTaskBatchId(jobContext.getTaskBatchId());
        mapTaskRequest.setTaskName(nextTaskName);
        mapTaskRequest.setSubTask(taskList);
        mapTaskRequest.setParentId(jobContext.getTaskId());
        mapTaskRequest.setWorkflowTaskBatchId(jobContext.getWorkflowTaskBatchId());
        mapTaskRequest.setWorkflowNodeId(jobContext.getWorkflowNodeId());
        Map changeWfContext = jobContext.getChangeWfContext();
        if (Objects.nonNull(changeWfContext)) {
            mapTaskRequest.setWfContext(JsonUtil.toJsonString((Object)changeWfContext));
        }
        Result<Boolean> result = CLIENT.batchReportMapTask(mapTaskRequest);
        if (!(StatusEnum.YES.getStatus().intValue() == result.getStatus() || Objects.nonNull(result.getData()) && ((Boolean)result.getData()).booleanValue())) {
            throw new SnailJobMapReduceException("map failed for task: {} errorMsg:{}", new Object[]{nextTaskName, result.getMessage()});
        }
        SnailJobLog.LOCAL.info("Map task create successfully!. taskName:[{}] TaskId:[{}] ", new Object[]{nextTaskName, jobContext.getTaskId()});
        return ExecuteResult.success();
    }
}

