/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.register;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.RpcClient;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientException;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.job.core.Scanner;
import com.aizuda.snailjob.client.job.core.cache.JobExecutorInfoCache;
import com.aizuda.snailjob.client.job.core.dto.JobExecutorInfo;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.model.dto.JobExecutorDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class JobExecutorRegistrar
implements Lifecycle {
    private final List<Scanner> scanners;
    private final List<JobExecutorDTO> contextList = new ArrayList<JobExecutorDTO>();
    public static RpcClient CLIENT;
    private static final Set<String> END_WITH_SET;
    private static final Set<String> EQUALS_SET;

    public void registerRetryHandler(JobExecutorInfo jobExecutorInfo) {
        SnailJobProperties properties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        String executorName = jobExecutorInfo.getExecutorName();
        if (JobExecutorInfoCache.isExisted(executorName)) {
            throw new SnailJobClientException("Duplicate executor names are not allowed: {}", (Object)executorName);
        }
        JobExecutorInfoCache.put(jobExecutorInfo);
        for (String suffix : END_WITH_SET) {
            if (!executorName.endsWith(suffix)) continue;
            return;
        }
        if (EQUALS_SET.contains(executorName)) {
            return;
        }
        JobExecutorDTO jobExecutorDTO = new JobExecutorDTO();
        jobExecutorDTO.setExecutorInfo(executorName);
        this.contextList.add(jobExecutorDTO);
    }

    public void registerRetryHandler(List<JobExecutorInfo> contextList) {
        for (JobExecutorInfo jobExecutorInfo : contextList) {
            this.registerRetryHandler(jobExecutorInfo);
        }
    }

    public void start() {
        CLIENT = (RpcClient)RequestBuilder.newBuilder().client(RpcClient.class).callback(rpcResult -> {
            if (StatusEnum.NO.getStatus().equals(rpcResult.getStatus())) {
                SnailJobLog.LOCAL.error("Job executors register error requestId:[{}] message:[{}]", new Object[]{rpcResult.getReqId(), rpcResult.getMessage()});
            }
        }).build();
        for (Scanner scanner : this.scanners) {
            this.registerRetryHandler(scanner.doScan());
        }
        try {
            if (!this.contextList.isEmpty()) {
                CLIENT.registryExecutors(this.contextList);
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Job executors register error", new Object[]{e});
        }
    }

    public void close() {
    }

    @Generated
    public JobExecutorRegistrar(List<Scanner> scanners) {
        this.scanners = scanners;
    }

    static {
        END_WITH_SET = new HashSet<String>(Arrays.asList("AnnotationJobExecutor", "AnnotationMapJobExecutor", "AnnotationMapReduceJobExecutor"));
        EQUALS_SET = new HashSet<String>(Arrays.asList("snailJobCMDJobExecutor", "snailJobHttpExecutor", "snailJobPowerShellJobExecutor", "snailJobShellJobExecutor"));
    }
}

