/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DatePattern;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.job.core.cache.ThreadPoolCache;
import com.aizuda.snailjob.client.job.core.client.JobNettyClient;
import com.aizuda.snailjob.client.job.core.log.JobLogMeta;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.client.model.request.DispatchJobResultRequest;
import com.aizuda.snailjob.common.core.alarm.AlarmContext;
import com.aizuda.snailjob.common.core.alarm.SnailJobAlarmFactory;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.JobNotifySceneEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.JobContext;
import com.aizuda.snailjob.common.core.util.EnvironmentUtils;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.aizuda.snailjob.server.model.dto.ConfigDTO;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobExecutorFutureCallback
implements FutureCallback<ExecuteResult> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobExecutorFutureCallback.class);
    private static final String TEXT_MESSAGE_FORMATTER = "<font face=\"\u5fae\u8f6f\u96c5\u9ed1\" color=#ff0000 size=4>{}\u73af\u5883 \u5b9a\u65f6\u4efb\u52a1\u4e0a\u62a5\u5f02\u5e38</font>  \n > IP:{}    \n > \u7a7a\u95f4ID:{}   \n > \u540d\u79f0:{}    \n > \u65f6\u95f4:{}    \n > \u5f02\u5e38:{}  \n ";
    private static final JobNettyClient CLIENT = (JobNettyClient)RequestBuilder.newBuilder().client(JobNettyClient.class).callback(nettyResult -> {
        if (nettyResult.getStatus() == StatusEnum.NO.getStatus().intValue()) {
            JobExecutorFutureCallback.sendMessage(nettyResult.getMessage());
        }
        SnailJobLog.LOCAL.debug("Job execute result report successfully requestId:[{}]", new Object[]{nettyResult.getReqId()});
    }).build();
    private final JobContext jobContext;

    public JobExecutorFutureCallback(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public void onSuccess(ExecuteResult result) {
        try {
            this.initLogContext();
            SnailJobLog.REMOTE.info("\u4efb\u52a1\u6267\u884c\u6210\u529f taskBatchId:[{}] [{}]", new Object[]{this.jobContext.getTaskBatchId(), JsonUtil.toJsonString((Object)result)});
            if (Objects.isNull(result)) {
                result = ExecuteResult.success();
            }
            int taskStatus = result.getStatus() == StatusEnum.NO.getStatus().intValue() ? JobTaskStatusEnum.FAIL.getStatus() : JobTaskStatusEnum.SUCCESS.getStatus();
            CLIENT.dispatchResult(this.buildDispatchJobResultRequest(result, taskStatus));
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38.[{}]", new Object[]{this.jobContext.getTaskId(), e});
            JobExecutorFutureCallback.sendMessage(e.getMessage());
        }
        finally {
            SnailJobLogManager.removeLogMeta();
            this.stopThreadPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Throwable t) {
        if (t instanceof CancellationException) {
            SnailJobLog.LOCAL.debug("\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\uff0c\u4e0d\u505a\u72b6\u6001\u56de\u4f20", new Object[0]);
            return;
        }
        ExecuteResult failure = ExecuteResult.failure();
        try {
            this.initLogContext();
            SnailJobLog.REMOTE.error("\u4efb\u52a1\u6267\u884c\u5931\u8d25 taskBatchId:[{}]", new Object[]{this.jobContext.getTaskBatchId(), t});
            failure.setMessage(t.getMessage());
            CLIENT.dispatchResult(this.buildDispatchJobResultRequest(failure, JobTaskStatusEnum.FAIL.getStatus()));
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38.[{}]", new Object[]{this.jobContext.getTaskId(), e});
            JobExecutorFutureCallback.sendMessage(e.getMessage());
        }
        finally {
            SnailJobLogManager.removeLogMeta();
            this.stopThreadPool();
        }
    }

    private void initLogContext() {
        JobLogMeta logMeta = new JobLogMeta();
        logMeta.setNamespaceId(this.jobContext.getNamespaceId());
        logMeta.setTaskId(this.jobContext.getTaskId());
        logMeta.setGroupName(this.jobContext.getGroupName());
        logMeta.setJobId(this.jobContext.getJobId());
        logMeta.setTaskBatchId(this.jobContext.getTaskBatchId());
        SnailJobLogManager.initLogInfo((LogMeta)logMeta, (LogTypeEnum)LogTypeEnum.JOB);
    }

    private void stopThreadPool() {
        if (this.jobContext.getTaskType().intValue() == JobTaskTypeEnum.CLUSTER.getType()) {
            ThreadPoolCache.stopThreadPool(this.jobContext.getTaskBatchId());
        }
    }

    private DispatchJobResultRequest buildDispatchJobResultRequest(ExecuteResult executeResult, int status) {
        DispatchJobResultRequest dispatchJobRequest = new DispatchJobResultRequest();
        dispatchJobRequest.setTaskBatchId(this.jobContext.getTaskBatchId());
        dispatchJobRequest.setGroupName(this.jobContext.getGroupName());
        dispatchJobRequest.setJobId(this.jobContext.getJobId());
        dispatchJobRequest.setTaskId(this.jobContext.getTaskId());
        dispatchJobRequest.setWorkflowTaskBatchId(this.jobContext.getWorkflowTaskBatchId());
        dispatchJobRequest.setWorkflowNodeId(this.jobContext.getWorkflowNodeId());
        dispatchJobRequest.setTaskBatchId(this.jobContext.getTaskBatchId());
        dispatchJobRequest.setTaskId(this.jobContext.getTaskId());
        dispatchJobRequest.setTaskType(this.jobContext.getTaskType());
        dispatchJobRequest.setExecuteResult(executeResult);
        dispatchJobRequest.setTaskStatus(Integer.valueOf(status));
        dispatchJobRequest.setRetryStatus(this.jobContext.getRetryStatus());
        dispatchJobRequest.setRetryScene(this.jobContext.getRetryScene());
        if (CollUtil.isNotEmpty((Map)this.jobContext.getChangeWfContext())) {
            dispatchJobRequest.setWfContext(JsonUtil.toJsonString((Object)this.jobContext.getChangeWfContext()));
        }
        return dispatchJobRequest;
    }

    private static void sendMessage(String message) {
        try {
            SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
            if (Objects.isNull(snailJobProperties)) {
                return;
            }
            ConfigDTO.Notify notify = GroupVersionCache.getJobNotifyAttribute((Integer)JobNotifySceneEnum.JOB_CLIENT_ERROR.getNotifyScene());
            if (Objects.nonNull(notify)) {
                List recipients = Optional.ofNullable(notify.getRecipients()).orElse(Lists.newArrayList());
                for (ConfigDTO.Notify.Recipient recipient : recipients) {
                    AlarmContext context = AlarmContext.build().text(TEXT_MESSAGE_FORMATTER, new Object[]{EnvironmentUtils.getActiveProfile(), NetUtil.getLocalIpStr(), snailJobProperties.getNamespace(), snailJobProperties.getGroup(), LocalDateTime.now().format(DatePattern.NORM_DATETIME_FORMATTER), message}).title("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u679c\u4e0a\u62a5\u5f02\u5e38:[{}]", new Object[]{snailJobProperties.getGroup()}).notifyAttribute(recipient.getNotifyAttribute());
                    Optional.ofNullable(SnailJobAlarmFactory.getAlarmType((Integer)recipient.getNotifyType())).ifPresent(alarm -> alarm.asyncSendMessage((Object)context));
                }
            }
        }
        catch (Exception e1) {
            SnailJobLog.LOCAL.error("Client failed to send component exception alert.", new Object[]{e1});
        }
    }
}

