/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.job.core.executor;

import com.aizuda.snailjob.client.common.log.report.LogMeta;
import com.aizuda.snailjob.client.common.log.support.SnailJobLogManager;
import com.aizuda.snailjob.client.job.core.IJobExecutor;
import com.aizuda.snailjob.client.job.core.cache.FutureCache;
import com.aizuda.snailjob.client.job.core.cache.ThreadPoolCache;
import com.aizuda.snailjob.client.job.core.dto.JobArgs;
import com.aizuda.snailjob.client.job.core.dto.ShardingJobArgs;
import com.aizuda.snailjob.client.job.core.executor.JobExecutorFutureCallback;
import com.aizuda.snailjob.client.job.core.log.JobLogMeta;
import com.aizuda.snailjob.client.job.core.timer.StopTaskTimerTask;
import com.aizuda.snailjob.client.job.core.timer.TimerManager;
import com.aizuda.snailjob.client.model.ExecuteResult;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.model.JobContext;
import com.aizuda.snailjob.common.log.enums.LogTypeEnum;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobExecutor
implements IJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(AbstractJobExecutor.class);

    @Override
    public void jobExecute(JobContext jobContext) {
        ThreadPoolExecutor threadPool = ThreadPoolCache.createThreadPool(jobContext.getTaskBatchId(), jobContext.getParallelNum());
        ListeningExecutorService decorator = MoreExecutors.listeningDecorator((ExecutorService)threadPool);
        TimerManager.add(new StopTaskTimerTask(jobContext.getTaskBatchId()), jobContext.getExecutorTimeout().intValue(), TimeUnit.SECONDS);
        ListenableFuture submit = decorator.submit(() -> {
            JobArgs jobArgs = jobContext.getTaskType().intValue() == JobTaskTypeEnum.SHARDING.getType() ? AbstractJobExecutor.buildShardingJobArgs(jobContext) : AbstractJobExecutor.buildJobArgs(jobContext);
            try {
                this.initLogContext(jobContext);
                ExecuteResult executeResult = this.doJobExecute(jobArgs);
                return executeResult;
            }
            finally {
                SnailJobLogManager.removeLogMeta();
            }
        });
        FutureCache.addFuture(jobContext.getTaskBatchId(), (ListenableFuture<ExecuteResult>)submit);
        Futures.addCallback((ListenableFuture)submit, (FutureCallback)new JobExecutorFutureCallback(jobContext), (Executor)decorator);
    }

    private void initLogContext(JobContext jobContext) {
        JobLogMeta logMeta = new JobLogMeta();
        logMeta.setNamespaceId(jobContext.getNamespaceId());
        logMeta.setTaskId(jobContext.getTaskId());
        logMeta.setGroupName(jobContext.getGroupName());
        logMeta.setJobId(jobContext.getJobId());
        logMeta.setTaskBatchId(jobContext.getTaskBatchId());
        SnailJobLogManager.initLogInfo((LogMeta)logMeta, (LogTypeEnum)LogTypeEnum.JOB);
    }

    private static JobArgs buildJobArgs(JobContext jobContext) {
        JobArgs jobArgs = new JobArgs();
        jobArgs.setArgsStr(jobContext.getArgsStr());
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setTaskBatchId(jobContext.getTaskBatchId());
        return jobArgs;
    }

    private static JobArgs buildShardingJobArgs(JobContext jobContext) {
        ShardingJobArgs jobArgs = new ShardingJobArgs();
        jobArgs.setArgsStr(jobContext.getArgsStr());
        jobArgs.setExecutorInfo(jobContext.getExecutorInfo());
        jobArgs.setShardingIndex(jobContext.getShardingIndex());
        jobArgs.setShardingTotal(jobContext.getShardingTotal());
        return jobArgs;
    }

    protected abstract ExecuteResult doJobExecute(JobArgs var1);
}

