/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.handler;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.RpcClient;
import com.aizuda.snailjob.client.common.cache.GroupVersionCache;
import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.model.request.ConfigRequest;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.springframework.stereotype.Component;

@Component
public class SyncRemoteConfig
implements Lifecycle {
    private static RpcClient CLIENT;
    private static final ScheduledExecutorService SCHEDULE_EXECUTOR;

    @Override
    public void start() {
        CLIENT = RequestBuilder.newBuilder().client(RpcClient.class).timeout(1000L).callback(rpcResult -> {
            if (Objects.isNull(rpcResult.getData())) {
                SnailJobLog.LOCAL.debug("Configuration retrieval result is null", new Object[0]);
                return;
            }
            GroupVersionCache.setConfig((ConfigRequest)JsonUtil.parseObject((String)rpcResult.getData().toString(), ConfigRequest.class));
        }).build();
        SCHEDULE_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                CLIENT.syncRemoteConfig();
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Notification configuration failed", new Object[]{e});
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void close() {
    }

    static {
        SCHEDULE_EXECUTOR = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "sync-remote-config"));
    }
}

