/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client.netty;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.netty.NettyChannel;
import com.aizuda.snailjob.client.common.rpc.client.netty.NettyHttpClientHandler;
import com.aizuda.snailjob.common.log.SnailJobLog;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
public class NettyHttpConnectClient
implements Lifecycle {
    private final SnailJobProperties snailJobProperties;
    private static final NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup();
    private static final Bootstrap bootstrap = new Bootstrap();
    private Channel channel;

    @Override
    public void start() {
        try {
            final NettyHttpConnectClient thisClient = this;
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)nioEventLoopGroup)).channel(NioSocketChannel.class)).remoteAddress(NettyChannel.getServerHost(), NettyChannel.getServerPort()).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 30L, TimeUnit.SECONDS)}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)}).addLast(new ChannelHandler[]{new NettyHttpClientHandler(thisClient)});
                }
            })).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
            this.connect();
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Client start exception", new Object[]{e});
        }
    }

    public void connect() {
        try {
            ChannelFuture channelFuture = bootstrap.connect();
            boolean notTimeout = channelFuture.awaitUninterruptibly(30L, TimeUnit.SECONDS);
            this.channel = channelFuture.channel();
            if (notTimeout) {
                if (this.channel != null && this.channel.isActive()) {
                    SnailJobLog.LOCAL.info("netty client started {} connect to server", new Object[]{this.channel.localAddress()});
                    NettyChannel.setChannel(this.getChannel());
                    return;
                }
                Throwable cause = channelFuture.cause();
                if (cause != null) {
                    this.exceptionHandler(cause);
                }
            } else {
                SnailJobLog.LOCAL.warn("connect remote host[{}] timeout {}s", new Object[]{this.channel.remoteAddress(), 30});
            }
        }
        catch (Exception e) {
            this.exceptionHandler(e);
        }
        if (Objects.nonNull(this.channel)) {
            this.channel.close();
        }
    }

    public void reconnect() {
        ChannelFuture channelFuture = bootstrap.remoteAddress(NettyChannel.getServerHost(), NettyChannel.getServerPort()).connect();
        channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            Throwable cause = future.cause();
            if (cause != null) {
                this.exceptionHandler(cause);
            } else {
                this.channel = channelFuture.channel();
                if (this.channel != null && this.channel.isActive()) {
                    SnailJobLog.LOCAL.info("Netty client {} reconnect to server", new Object[]{this.channel.localAddress()});
                    NettyChannel.setChannel(this.getChannel());
                }
            }
        }));
    }

    private void exceptionHandler(Throwable cause) {
        if (cause instanceof ConnectException) {
            SnailJobLog.LOCAL.error("connect error:{}", new Object[]{cause.getMessage()});
        } else if (cause instanceof ClosedChannelException) {
            SnailJobLog.LOCAL.error("connect error:{}", new Object[]{"client has destroy"});
        } else {
            SnailJobLog.LOCAL.error("connect error:", new Object[]{cause});
        }
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        nioEventLoopGroup.shutdownGracefully();
    }

    @Generated
    public SnailJobProperties getSnailJobProperties() {
        return this.snailJobProperties;
    }

    @Generated
    public Channel getChannel() {
        return this.channel;
    }

    @Generated
    public NettyHttpConnectClient(SnailJobProperties snailJobProperties) {
        this.snailJobProperties = snailJobProperties;
    }
}

