/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.supports.handler.netty;

import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.supports.handler.SnailDispatcherRequestHandler;
import com.aizuda.snailjob.client.common.rpc.supports.handler.netty.NettyHttpRequest;
import com.aizuda.snailjob.client.common.rpc.supports.http.HttpRequest;
import com.aizuda.snailjob.client.common.rpc.supports.http.HttpResponse;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.model.SnailJobRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final ThreadPoolExecutor dispatcherThreadPool;
    private final SnailDispatcherRequestHandler dispatcher;

    public NettyHttpServerHandler(SnailDispatcherRequestHandler snailDispatcherRequestHandler, SnailJobProperties snailJobProperties) {
        this.dispatcher = snailDispatcherRequestHandler;
        SnailJobProperties.RpcServerProperties rpcServerProperties = snailJobProperties.getServerRpc();
        SnailJobProperties.ThreadPoolConfig threadPool = rpcServerProperties.getDispatcherTp();
        this.dispatcherThreadPool = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), threadPool.getTimeUnit(), new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), (ThreadFactory)new CustomizableThreadFactory("snail-netty-server-"));
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) {
        String content = fullHttpRequest.content().toString(CharsetUtil.UTF_8);
        HttpHeaders headers = fullHttpRequest.headers();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (Map.Entry header : headers) {
            headerMap.put((String)header.getKey(), (String)header.getValue());
        }
        String uri = fullHttpRequest.uri();
        NettyHttpRequest nettyHttpRequest = NettyHttpRequest.builder().keepAlive(HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest)).uri(uri).channelHandlerContext(channelHandlerContext).method(fullHttpRequest.method()).headers(headers).content(content).httpResponse(new HttpResponse()).httpRequest(new HttpRequest(headerMap, uri)).build();
        this.dispatcherThreadPool.execute(() -> {
            SnailJobRpcResult snailJobRpcResult = null;
            try {
                snailJobRpcResult = this.dispatcher.dispatch(nettyHttpRequest);
            }
            catch (Exception e) {
                SnailJobRequest retryRequest = (SnailJobRequest)JsonUtil.parseObject((String)content, SnailJobRequest.class);
                snailJobRpcResult = new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), e.getMessage(), null, retryRequest.getReqId());
            }
            finally {
                this.writeResponse(channelHandlerContext, HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest), nettyHttpRequest.getHttpResponse(), JsonUtil.toJsonString((Object)snailJobRpcResult));
            }
        });
    }

    private void writeResponse(ChannelHandlerContext ctx, boolean keepAlive, HttpResponse httpResponse, String responseJson) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.copiedBuffer((CharSequence)responseJson, (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        Map<String, Object> headers = httpResponse.getHeaders();
        headers.forEach((arg_0, arg_1) -> NettyHttpServerHandler.lambda$writeResponse$1((FullHttpResponse)response, arg_0, arg_1));
        ctx.writeAndFlush((Object)response);
    }

    private static /* synthetic */ void lambda$writeResponse$1(FullHttpResponse response, String key, Object value) {
        response.headers().set(key, value);
    }
}

