/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.supports.handler.grpc;

import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.supports.handler.SnailDispatcherRequestHandler;
import com.aizuda.snailjob.client.common.rpc.supports.handler.grpc.GrpcRequest;
import com.aizuda.snailjob.client.common.rpc.supports.http.HttpRequest;
import com.aizuda.snailjob.client.common.rpc.supports.http.HttpResponse;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.grpc.auto.Metadata;
import com.aizuda.snailjob.common.core.grpc.auto.SnailJobGrpcRequest;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class UnaryRequestHandler
implements ServerCalls.UnaryMethod<SnailJobGrpcRequest, GrpcResult> {
    private final ThreadPoolExecutor dispatcherThreadPool;
    private final SnailDispatcherRequestHandler dispatcher;

    public UnaryRequestHandler(SnailJobProperties.ThreadPoolConfig dispatcherThreadPool, SnailDispatcherRequestHandler handler) {
        this.dispatcher = handler;
        this.dispatcherThreadPool = new ThreadPoolExecutor(dispatcherThreadPool.getCorePoolSize(), dispatcherThreadPool.getMaximumPoolSize(), dispatcherThreadPool.getKeepAliveTime(), dispatcherThreadPool.getTimeUnit(), new LinkedBlockingQueue<Runnable>(dispatcherThreadPool.getQueueCapacity()), (ThreadFactory)new CustomizableThreadFactory("snail-grpc-server-"));
    }

    public void invoke(SnailJobGrpcRequest snailJobRequest, StreamObserver<GrpcResult> streamObserver) {
        Metadata metadata = snailJobRequest.getMetadata();
        GrpcRequest grpcRequest = GrpcRequest.builder().httpRequest(new HttpRequest(metadata.getHeadersMap(), metadata.getUri())).httpResponse(new HttpResponse()).snailJobRequest(snailJobRequest).build();
        this.dispatcherThreadPool.execute(() -> {
            SnailJobRpcResult snailJobRpcResult = null;
            try {
                snailJobRpcResult = this.dispatcher.dispatch(grpcRequest);
            }
            catch (Exception e) {
                snailJobRpcResult = new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), e.getMessage(), null, 0L);
            }
            finally {
                GrpcResult grpcResult = GrpcResult.newBuilder().setStatus(snailJobRpcResult.getStatus()).setMessage(Optional.ofNullable(snailJobRpcResult.getMessage()).orElse("")).setData(JsonUtil.toJsonString((Object)snailJobRpcResult.getData())).build();
                streamObserver.onNext((Object)grpcResult);
                streamObserver.onCompleted();
            }
        });
    }
}

