/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import cn.hutool.core.date.StopWatch;
import com.aizuda.snailjob.client.common.annotation.Mapping;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.exception.SnailJobClientTimeOutException;
import com.aizuda.snailjob.client.common.rpc.client.GrpcChannel;
import com.aizuda.snailjob.common.core.context.SnailSpringContext;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.grpc.auto.GrpcResult;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.model.SnailJobRpcResult;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class GrpcClientInvokeHandler<R extends Result<Object>>
implements InvocationHandler {
    public static final AtomicLong REQUEST_ID = new AtomicLong(0L);
    private final Consumer<R> consumer;
    private final boolean async;
    private final long timeout;
    private final TimeUnit unit;
    private static final ExecutorService executorService = GrpcClientInvokeHandler.createGrpcExecutor();
    private static final ScheduledThreadPoolExecutor schedule = new ScheduledThreadPoolExecutor(1);

    public GrpcClientInvokeHandler(boolean async, long timeout, TimeUnit unit, Consumer<R> consumer) {
        this.consumer = consumer;
        this.async = async;
        this.timeout = timeout;
        this.unit = unit;
    }

    public R invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StopWatch sw = new StopWatch();
        Mapping annotation = method.getAnnotation(Mapping.class);
        final long reqId = GrpcClientInvokeHandler.newId();
        ListenableFuture<GrpcResult> future = GrpcChannel.sendOfUnary(annotation.path(), JsonUtil.toJsonString((Object)args), reqId);
        SnailJobLog.LOCAL.debug("request complete requestId:[{}] \u8017\u65f6:[{}ms]", new Object[]{sw.getTotalTimeMillis(), reqId});
        if (future == null) {
            return (R)new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), "future is nulll", null, reqId);
        }
        if (this.async) {
            Futures.addCallback(future, (FutureCallback)new FutureCallback<GrpcResult>(){

                public void onSuccess(GrpcResult result) {
                    Object obj = JsonUtil.parseObject((String)result.getData(), Object.class);
                    GrpcClientInvokeHandler.this.consumer.accept(new SnailJobRpcResult(result.getStatus(), result.getMessage(), obj, result.getReqId()));
                }

                public void onFailure(Throwable t) {
                    GrpcClientInvokeHandler.this.consumer.accept(new SnailJobRpcResult(StatusEnum.NO.getStatus().intValue(), t.getMessage(), null, reqId));
                }
            }, (Executor)executorService);
            Futures.withTimeout(future, (long)this.timeout, (TimeUnit)this.unit, (ScheduledExecutorService)schedule);
            return null;
        }
        try {
            GrpcResult result = (GrpcResult)future.get(this.timeout, this.unit);
            Object obj = JsonUtil.parseObject((String)result.getData(), Object.class);
            return (R)new SnailJobRpcResult(result.getStatus(), result.getMessage(), obj, result.getReqId());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        catch (TimeoutException e) {
            throw new SnailJobClientTimeOutException("Request to remote interface timed out. path:[{}]", (Object)annotation.path());
        }
    }

    private static long newId() {
        return REQUEST_ID.getAndIncrement();
    }

    protected static ThreadPoolExecutor createGrpcExecutor() {
        SnailJobProperties snailJobProperties = (SnailJobProperties)SnailSpringContext.getBean(SnailJobProperties.class);
        SnailJobProperties.RpcClientProperties clientRpc = snailJobProperties.getClientRpc();
        String serverIp = GrpcChannel.getServerHost().replaceAll("%", "-");
        SnailJobProperties.ThreadPoolConfig threadPool = clientRpc.getClientTp();
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-client-executor-" + serverIp + "-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }
}

