/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.supports.scan;

import com.aizuda.snailjob.client.common.annotation.Mapping;
import com.aizuda.snailjob.client.common.annotation.SnailEndPoint;
import com.aizuda.snailjob.client.common.rpc.supports.scan.EndPointInfo;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;

@Component
public class SnailEndPointScanner
implements ApplicationContextAware {
    private ApplicationContext context;

    public List<EndPointInfo> doScan() {
        return this.scanEndPoint();
    }

    private List<EndPointInfo> scanEndPoint() {
        String[] beanDefinitionNames;
        ArrayList<EndPointInfo> endPointInfoList = new ArrayList<EndPointInfo>();
        for (String beanDefinitionName : beanDefinitionNames = this.context.getBeanNamesForType(Object.class, false, true)) {
            Object bean = this.context.getBean(beanDefinitionName);
            Class executorNotProxy = AopProxyUtils.ultimateTargetClass((Object)bean);
            String executorClassName = executorNotProxy.getName();
            SnailEndPoint jobExecutor = bean.getClass().getAnnotation(SnailEndPoint.class);
            if (!Objects.nonNull(jobExecutor)) continue;
            Map annotatedMethods = null;
            try {
                annotatedMethods = MethodIntrospector.selectMethods(bean.getClass(), method -> (Mapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Mapping.class));
            }
            catch (Throwable ex) {
                SnailJobLog.LOCAL.error("{} Mapping\u52a0\u8f7d\u5f02\u5e38\uff1a{}", new Object[]{beanDefinitionName, ex});
            }
            for (Map.Entry entry : annotatedMethods.entrySet()) {
                Method method2 = (Method)entry.getKey();
                Mapping mapping = (Mapping)entry.getValue();
                endPointInfoList.add(EndPointInfo.builder().executorName(executorClassName).method(method2).executor(bean).path(mapping.path()).requestMethod(mapping.method()).build());
            }
        }
        return endPointInfoList;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

