/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.rpc.client;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.config.SnailJobProperties;
import com.aizuda.snailjob.client.common.rpc.client.GrpcChannel;
import com.aizuda.snailjob.common.core.enums.RpcTypeEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class SnailJobGrpcClient
implements Lifecycle {
    private ManagedChannel channel;
    private final SnailJobProperties snailJobProperties;

    @Override
    public void start() {
        if (RpcTypeEnum.GRPC != this.snailJobProperties.getRpcType()) {
            return;
        }
        SnailJobProperties.RpcClientProperties clientRpc = this.snailJobProperties.getClientRpc();
        String serverHost = GrpcChannel.getServerHost();
        this.channel = ManagedChannelBuilder.forAddress((String)serverHost, (int)GrpcChannel.getServerPort()).executor((Executor)this.createGrpcExecutor(serverHost)).decompressorRegistry(DecompressorRegistry.getDefaultInstance()).maxInboundMessageSize(clientRpc.getMaxInboundMessageSize()).keepAliveTime(clientRpc.getKeepAliveTime().toMillis(), TimeUnit.MILLISECONDS).keepAliveTimeout(clientRpc.getKeepAliveTimeout().toMillis(), TimeUnit.MILLISECONDS).usePlaintext().build();
        GrpcChannel.setChannel(this.channel);
        SnailJobLog.LOCAL.info("grpc client started connect to server", new Object[0]);
    }

    @Override
    public void close() {
        if (this.channel != null && !this.channel.isShutdown()) {
            this.channel.shutdownNow();
        }
    }

    private ThreadPoolExecutor createGrpcExecutor(String serverIp) {
        SnailJobProperties.RpcClientProperties clientRpc = this.snailJobProperties.getClientRpc();
        SnailJobProperties.ThreadPoolConfig threadPool = clientRpc.getClientTp();
        serverIp = serverIp.replaceAll("%", "-");
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(threadPool.getCorePoolSize(), threadPool.getMaximumPoolSize(), threadPool.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(threadPool.getQueueCapacity()), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("snail-job-grpc-client-executor-" + serverIp + "-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    @Generated
    public SnailJobGrpcClient(SnailJobProperties snailJobProperties) {
        this.snailJobProperties = snailJobProperties;
    }
}

