/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.common.init;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.common.event.SnailClientStartedEvent;
import com.aizuda.snailjob.client.common.event.SnailClientStartingEvent;
import com.aizuda.snailjob.common.core.context.SpringContext;
import com.aizuda.snailjob.common.core.util.SnailJobVersion;
import com.aizuda.snailjob.common.log.SnailJobLog;
import java.util.List;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
public class SnailJobStartListener
implements ApplicationRunner {
    private final List<Lifecycle> lifecycleList;
    private volatile boolean isStarted = false;

    public void run(ApplicationArguments args) throws Exception {
        if (this.isStarted) {
            SnailJobLog.LOCAL.info("snail-job client already started v{}", new Object[]{SnailJobVersion.getVersion()});
            return;
        }
        System.out.println(MessageFormatter.format((String)"  ______                  _  __       _____      __        \n.' ____ \\                (_)[  |     |_   _|    [  |       \n| (___ \\_| _ .--.  ,--.  __  | |       | | .--.  | |.--.   \n _.____`. [ `.-. |`'_\\ :[  | | |   _   | / .'`\\ \\| '/'`\\ \\ \n| \\____) | | | | |// | |,| | | |  | |__' | \\__. ||  \\__/ | \n \\______.'[___||__]'-;__[___|___] `.____.''.__.'[__;.__.'  \n:: Snail Job ::                                 (v{})  \n", (Object)SnailJobVersion.getVersion()).getMessage());
        SnailJobLog.LOCAL.info("snail-job client is preparing to start... v{}", new Object[]{SnailJobVersion.getVersion()});
        SpringContext.getContext().publishEvent((ApplicationEvent)new SnailClientStartingEvent());
        this.lifecycleList.forEach(Lifecycle::start);
        SpringContext.getContext().publishEvent((ApplicationEvent)new SnailClientStartedEvent());
        this.isStarted = true;
        SnailJobLog.LOCAL.info("snail-job client started successfully v{}", new Object[]{SnailJobVersion.getVersion()});
    }

    public SnailJobStartListener(List<Lifecycle> lifecycleList) {
        this.lifecycleList = lifecycleList;
    }
}

