/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.strategy.WaitStrategies;
import com.aizuda.easy.retry.server.common.util.CronUtils;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.SceneConfigQueryVO;
import com.aizuda.easy.retry.server.web.model.request.SceneConfigRequestVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.SceneConfigResponseVO;
import com.aizuda.easy.retry.server.web.service.SceneConfigService;
import com.aizuda.easy.retry.server.web.service.convert.SceneConfigConverter;
import com.aizuda.easy.retry.server.web.service.convert.SceneConfigResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.access.ConfigAccess;
import com.aizuda.easy.retry.template.datasource.persistence.po.SceneConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneConfigServiceImpl
implements SceneConfigService {
    @Autowired
    private AccessTemplate accessTemplate;

    @Override
    public PageResult<List<SceneConfigResponseVO>> getSceneConfigPageList(SceneConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        LambdaQueryWrapper sceneConfigLambdaQueryWrapper = new LambdaQueryWrapper();
        sceneConfigLambdaQueryWrapper.eq(SceneConfig::getNamespaceId, (Object)namespaceId);
        if (userSessionVO.isUser()) {
            sceneConfigLambdaQueryWrapper.in(SceneConfig::getGroupName, userSessionVO.getGroupNames());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            sceneConfigLambdaQueryWrapper.eq(SceneConfig::getGroupName, (Object)queryVO.getGroupName().trim());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getSceneName())) {
            sceneConfigLambdaQueryWrapper.eq(SceneConfig::getSceneName, (Object)queryVO.getSceneName().trim());
        }
        pageDTO = this.accessTemplate.getSceneConfigAccess().listPage(pageDTO, (LambdaQueryWrapper)sceneConfigLambdaQueryWrapper.orderByDesc(SceneConfig::getCreateDt));
        return new PageResult<List<SceneConfigResponseVO>>(pageDTO, SceneConfigResponseVOConverter.INSTANCE.batchConvert(pageDTO.getRecords()));
    }

    @Override
    public List<SceneConfigResponseVO> getSceneConfigList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List sceneConfigs = this.accessTemplate.getSceneConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{SceneConfig::getSceneName, SceneConfig::getDescription, SceneConfig::getMaxRetryCount}).eq(SceneConfig::getNamespaceId, (Object)namespaceId)).eq(SceneConfig::getGroupName, (Object)groupName)).orderByDesc(SceneConfig::getCreateDt));
        return SceneConfigResponseVOConverter.INSTANCE.batchConvert(sceneConfigs);
    }

    @Override
    public Boolean saveSceneConfig(SceneConfigRequestVO requestVO) {
        SceneConfigServiceImpl.checkExecuteInterval(requestVO);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        Assert.isTrue((0L == sceneConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SceneConfig::getNamespaceId, (Object)namespaceId)).eq(SceneConfig::getGroupName, (Object)requestVO.getGroupName())).eq(SceneConfig::getSceneName, (Object)requestVO.getSceneName())) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u573a\u666f\u540d\u79f0\u91cd\u590d. {}", new Object[]{requestVO.getSceneName()}));
        SceneConfig sceneConfig = SceneConfigConverter.INSTANCE.toSceneConfigRequestVO(requestVO);
        sceneConfig.setCreateDt(LocalDateTime.now());
        sceneConfig.setNamespaceId(namespaceId);
        Assert.isTrue((1 == sceneConfigAccess.insert((Object)sceneConfig) ? 1 : 0) != 0, () -> new EasyRetryServerException("failed to insert scene. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)sceneConfig)}));
        return Boolean.TRUE;
    }

    private static void checkExecuteInterval(SceneConfigRequestVO requestVO) {
        if (Lists.newArrayList((Object[])new Integer[]{WaitStrategies.WaitStrategyEnum.FIXED.getType(), WaitStrategies.WaitStrategyEnum.RANDOM.getType()}).contains(requestVO.getBackOff()) ? Integer.parseInt(requestVO.getTriggerInterval()) < 10 : requestVO.getBackOff().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType() && CronUtils.getExecuteInterval((String)requestVO.getTriggerInterval()) < 10000L) {
            throw new EasyRetryServerException("\u95f4\u9694\u65f6\u95f4\u4e0d\u5f97\u5c0f\u4e8e10");
        }
    }

    @Override
    public Boolean updateSceneConfig(SceneConfigRequestVO requestVO) {
        SceneConfigServiceImpl.checkExecuteInterval(requestVO);
        SceneConfig sceneConfig = SceneConfigConverter.INSTANCE.toSceneConfigRequestVO(requestVO);
        sceneConfig.setSceneName(null);
        sceneConfig.setGroupName(null);
        sceneConfig.setNamespaceId(null);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        sceneConfig.setTriggerInterval(Optional.ofNullable(sceneConfig.getTriggerInterval()).orElse(""));
        Assert.isTrue((1 == this.accessTemplate.getSceneConfigAccess().update((Object)sceneConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SceneConfig::getNamespaceId, (Object)namespaceId)).eq(SceneConfig::getGroupName, (Object)requestVO.getGroupName())).eq(SceneConfig::getSceneName, (Object)requestVO.getSceneName())) ? 1 : 0) != 0, () -> new EasyRetryServerException("failed to update scene. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)sceneConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public SceneConfigResponseVO getSceneConfigDetail(Long id) {
        SceneConfig sceneConfig = (SceneConfig)this.accessTemplate.getSceneConfigAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SceneConfig::getId, (Object)id));
        return SceneConfigResponseVOConverter.INSTANCE.convert(sceneConfig);
    }
}

