/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskLogQueryVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.RetryTaskLogMessageResponseVO;
import com.aizuda.easy.retry.server.web.model.response.RetryTaskLogResponseVO;
import com.aizuda.easy.retry.server.web.service.RetryTaskLogService;
import com.aizuda.easy.retry.server.web.service.convert.RetryTaskLogResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RetryTaskLogServiceImpl
implements RetryTaskLogService {
    private final RetryTaskLogMapper retryTaskLogMapper;
    private final RetryTaskLogMessageMapper retryTaskLogMessageMapper;

    @Override
    public PageResult<List<RetryTaskLogResponseVO>> getRetryTaskLogPage(RetryTaskLogQueryVO queryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper retryTaskLogLambdaQueryWrapper = new LambdaQueryWrapper();
        retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getNamespaceId, (Object)namespaceId);
        if (userSessionVO.isUser()) {
            retryTaskLogLambdaQueryWrapper.in(RetryTaskLog::getGroupName, userSessionVO.getGroupNames());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getGroupName, (Object)queryVO.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getSceneName())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getSceneName, (Object)queryVO.getSceneName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getBizNo())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getBizNo, (Object)queryVO.getBizNo());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getUniqueId, (Object)queryVO.getUniqueId());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getIdempotentId, (Object)queryVO.getIdempotentId());
        }
        retryTaskLogLambdaQueryWrapper.select(new SFunction[]{RetryTaskLog::getGroupName, RetryTaskLog::getId, RetryTaskLog::getSceneName, RetryTaskLog::getIdempotentId, RetryTaskLog::getBizNo, RetryTaskLog::getRetryStatus, RetryTaskLog::getCreateDt, RetryTaskLog::getUniqueId, RetryTaskLog::getTaskType});
        PageDTO retryTaskLogPageDTO = (PageDTO)this.retryTaskLogMapper.selectPage((IPage)pageDTO, (Wrapper)retryTaskLogLambdaQueryWrapper.orderByDesc(RetryTaskLog::getCreateDt));
        return new PageResult<List<RetryTaskLogResponseVO>>(retryTaskLogPageDTO, RetryTaskLogResponseVOConverter.INSTANCE.batchConvert(retryTaskLogPageDTO.getRecords()));
    }

    @Override
    public RetryTaskLogMessageResponseVO getRetryTaskLogMessagePage(RetryTaskLogMessageQueryVO queryVO) {
        RetryTaskLogMessage record;
        if (StrUtil.isBlank((CharSequence)queryVO.getUniqueId()) || StrUtil.isBlank((CharSequence)queryVO.getGroupName())) {
            RetryTaskLogMessageResponseVO jobLogResponseVO = new RetryTaskLogMessageResponseVO();
            jobLogResponseVO.setNextStartId(0L);
            jobLogResponseVO.setFromIndex(0);
            return jobLogResponseVO;
        }
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.select(new SFunction[]{RetryTaskLogMessage::getId, RetryTaskLogMessage::getLogNum});
        wrapper.ge(RetryTaskLogMessage::getId, (Object)queryVO.getStartId());
        wrapper.eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId);
        wrapper.eq(RetryTaskLogMessage::getUniqueId, (Object)queryVO.getUniqueId());
        wrapper.eq(RetryTaskLogMessage::getGroupName, (Object)queryVO.getGroupName());
        ((LambdaQueryWrapper)wrapper.orderByAsc(RetryTaskLogMessage::getId)).orderByAsc(RetryTaskLogMessage::getRealTime);
        PageDTO selectPage = (PageDTO)this.retryTaskLogMessageMapper.selectPage((IPage)pageDTO, (Wrapper)wrapper.orderByDesc(RetryTaskLogMessage::getCreateDt));
        List records = selectPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            RetryTaskLogMessageResponseVO jobLogResponseVO = new RetryTaskLogMessageResponseVO();
            jobLogResponseVO.setFinished(Boolean.TRUE);
            jobLogResponseVO.setNextStartId(queryVO.getStartId());
            jobLogResponseVO.setFromIndex(0);
            return jobLogResponseVO;
        }
        Integer fromIndex = Optional.ofNullable(queryVO.getFromIndex()).orElse(0);
        RetryTaskLogMessage firstRecord = (RetryTaskLogMessage)records.get(0);
        ArrayList ids = Lists.newArrayList((Object[])new Long[]{firstRecord.getId()});
        int total = firstRecord.getLogNum() - fromIndex;
        for (int i = 1; i < records.size() && total + (record = (RetryTaskLogMessage)records.get(i)).getLogNum() <= queryVO.getSize(); ++i) {
            total += record.getLogNum().intValue();
            ids.add(record.getId());
        }
        long nextStartId = 0L;
        List<Object> messages = Lists.newArrayList();
        List jobLogMessages = this.retryTaskLogMessageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryTaskLogMessage::getId, (Collection)ids)).orderByAsc(RetryTaskLogMessage::getId)).orderByAsc(RetryTaskLogMessage::getRealTime));
        for (RetryTaskLogMessage retryTaskLogMessage : jobLogMessages) {
            List originalList = (List)JsonUtil.parseObject((String)retryTaskLogMessage.getMessage(), List.class);
            int size = originalList.size() - fromIndex;
            List pageList = originalList.stream().skip(fromIndex.intValue()).limit(queryVO.getSize()).collect(Collectors.toList());
            if (messages.size() + size >= queryVO.getSize()) {
                messages.addAll(pageList);
                nextStartId = retryTaskLogMessage.getId();
                fromIndex = Math.min(fromIndex + queryVO.getSize(), originalList.size() - 1) + 1;
                break;
            }
            messages.addAll(pageList);
            nextStartId = retryTaskLogMessage.getId() + 1L;
            fromIndex = 0;
        }
        messages = messages.stream().sorted((o1, o2) -> {
            long value = Long.parseLong((String)o1.get("time_stamp")) - Long.parseLong((String)o2.get("time_stamp"));
            if (value > 0L) {
                return 1;
            }
            if (value < 0L) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        RetryTaskLogMessageResponseVO responseVO = new RetryTaskLogMessageResponseVO();
        responseVO.setMessage(messages);
        responseVO.setNextStartId(nextStartId);
        responseVO.setFromIndex(fromIndex);
        return responseVO;
    }

    @Override
    public RetryTaskLogResponseVO getRetryTaskLogById(Long id) {
        RetryTaskLog retryTaskLog = (RetryTaskLog)this.retryTaskLogMapper.selectById((Serializable)id);
        return RetryTaskLogResponseVOConverter.INSTANCE.convert(retryTaskLog);
    }

    public RetryTaskLogServiceImpl(RetryTaskLogMapper retryTaskLogMapper, RetryTaskLogMessageMapper retryTaskLogMessageMapper) {
        this.retryTaskLogMapper = retryTaskLogMapper;
        this.retryTaskLogMessageMapper = retryTaskLogMessageMapper;
    }
}

