/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.NamespaceQueryVO;
import com.aizuda.easy.retry.server.web.model.request.NamespaceRequestVO;
import com.aizuda.easy.retry.server.web.model.response.NamespaceResponseVO;
import com.aizuda.easy.retry.server.web.service.NamespaceService;
import com.aizuda.easy.retry.server.web.service.convert.NamespaceResponseVOConverter;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.NamespaceMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.Namespace;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NamespaceServiceImpl
implements NamespaceService {
    @Autowired
    private NamespaceMapper namespaceMapper;

    @Override
    public Boolean saveNamespace(NamespaceRequestVO namespaceRequestVO) {
        if (StrUtil.isNotBlank((CharSequence)namespaceRequestVO.getUniqueId())) {
            Assert.isTrue((this.namespaceMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Namespace::getUniqueId, (Object)namespaceRequestVO.getUniqueId())) == 0L ? 1 : 0) != 0, () -> new EasyRetryServerException("\u7a7a\u95f4\u552f\u4e00\u6807\u8bb0\u5df2\u7ecf\u5b58\u5728 {}", new Object[]{namespaceRequestVO.getUniqueId()}));
        }
        Namespace namespace = new Namespace();
        namespace.setName(namespaceRequestVO.getName());
        if (StrUtil.isBlank((CharSequence)namespaceRequestVO.getUniqueId())) {
            namespace.setUniqueId(IdUtil.simpleUUID());
        } else {
            namespace.setUniqueId(namespaceRequestVO.getUniqueId());
        }
        return 1 == this.namespaceMapper.insert((Object)namespace);
    }

    @Override
    public Boolean updateNamespace(NamespaceRequestVO namespaceRequestVO) {
        Long id = namespaceRequestVO.getId();
        Assert.notNull((Object)id, () -> new EasyRetryServerException("\u53c2\u6570\u9519\u8bef"));
        Namespace namespace = new Namespace();
        namespace.setName(namespaceRequestVO.getName());
        namespace.setId(id);
        return 1 == this.namespaceMapper.updateById((Object)namespace);
    }

    @Override
    public PageResult<List<NamespaceResponseVO>> getNamespacePage(NamespaceQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)queryVO.getKeyword())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.like(Namespace::getName, (Object)(queryVO.getKeyword().trim() + "%"))).or()).like(Namespace::getUniqueId, (Object)(queryVO.getKeyword().trim() + "%"));
        }
        queryWrapper.eq(Namespace::getDeleted, (Object)StatusEnum.NO.getStatus());
        queryWrapper.orderByDesc(Namespace::getId);
        PageDTO selectPage = (PageDTO)this.namespaceMapper.selectPage((IPage)pageDTO, (Wrapper)queryWrapper);
        return new PageResult<List<NamespaceResponseVO>>(pageDTO, NamespaceResponseVOConverter.INSTANCE.toNamespaceResponseVOs(selectPage.getRecords()));
    }

    @Override
    public Boolean deleteNamespace(Long id) {
        return 1 == this.namespaceMapper.deleteById((Serializable)id);
    }

    @Override
    public List<NamespaceResponseVO> getAllNamespace() {
        List namespaces = this.namespaceMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Namespace::getName, Namespace::getUniqueId}));
        return NamespaceResponseVOConverter.INSTANCE.toNamespaceResponseVOs(namespaces);
    }
}

