/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.JobTaskQueryVO;
import com.aizuda.easy.retry.server.web.model.response.JobTaskResponseVO;
import com.aizuda.easy.retry.server.web.service.JobTaskService;
import com.aizuda.easy.retry.server.web.service.convert.JobTaskResponseVOConverter;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobTaskServiceImpl
implements JobTaskService {
    @Autowired
    private JobTaskMapper jobTaskMapper;

    @Override
    public PageResult<List<JobTaskResponseVO>> getJobTaskPage(JobTaskQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (Objects.nonNull(queryVO.getJobId())) {
            queryWrapper.eq(JobTask::getJobId, (Object)queryVO.getJobId());
        }
        if (Objects.nonNull(queryVO.getTaskBatchId())) {
            queryWrapper.eq(JobTask::getTaskBatchId, (Object)queryVO.getTaskBatchId());
        }
        queryWrapper.orderByAsc(JobTask::getJobId);
        PageDTO selectPage = (PageDTO)this.jobTaskMapper.selectPage((IPage)pageDTO, (Wrapper)queryWrapper);
        List<JobTaskResponseVO> jobTaskResponseVOs = JobTaskResponseVOConverter.INSTANCE.toJobTaskResponseVOs(selectPage.getRecords());
        for (JobTaskResponseVO jobTaskResponseVO : jobTaskResponseVOs) {
            jobTaskResponseVO.setKey(jobTaskResponseVO.getId());
        }
        return new PageResult<List<JobTaskResponseVO>>(pageDTO, jobTaskResponseVOs);
    }
}

