/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.constant.SystemConstants;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.server.common.WaitStrategy;
import com.aizuda.easy.retry.server.common.config.SystemProperties;
import com.aizuda.easy.retry.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.strategy.WaitStrategies;
import com.aizuda.easy.retry.server.common.util.CronUtils;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.support.JobPrePareHandler;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.JobQueryVO;
import com.aizuda.easy.retry.server.web.model.request.JobRequestVO;
import com.aizuda.easy.retry.server.web.model.request.JobUpdateJobStatusRequestVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.JobResponseVO;
import com.aizuda.easy.retry.server.web.service.JobService;
import com.aizuda.easy.retry.server.web.service.convert.JobConverter;
import com.aizuda.easy.retry.server.web.service.convert.JobResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class JobServiceImpl
implements JobService {
    private static final Logger log = LoggerFactory.getLogger(JobServiceImpl.class);
    private final SystemProperties systemProperties;
    private final JobMapper jobMapper;
    @Lazy
    private final JobPrePareHandler terminalJobPrepareHandler;
    private final AccessTemplate accessTemplate;

    @Override
    public PageResult<List<JobResponseVO>> getJobPage(JobQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus());
        queryWrapper.eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId());
        if (userSessionVO.isUser()) {
            queryWrapper.in(Job::getGroupName, userSessionVO.getGroupNames());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            queryWrapper.eq(Job::getGroupName, (Object)queryVO.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getJobName())) {
            queryWrapper.like(Job::getJobName, (Object)(queryVO.getJobName().trim() + "%"));
        }
        if (Objects.nonNull(queryVO.getJobStatus())) {
            queryWrapper.eq(Job::getJobStatus, (Object)queryVO.getJobStatus());
        }
        queryWrapper.eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus());
        queryWrapper.orderByDesc(Job::getId);
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)pageDTO, (Wrapper)queryWrapper);
        List<JobResponseVO> jobResponseList = JobResponseVOConverter.INSTANCE.toJobResponseVOs(selectPage.getRecords());
        return new PageResult<List<JobResponseVO>>(pageDTO, jobResponseList);
    }

    @Override
    public JobResponseVO getJobDetail(Long id) {
        Job job = (Job)this.jobMapper.selectById((Serializable)id);
        return JobResponseVOConverter.INSTANCE.toJobResponseVO(job);
    }

    @Override
    public List<String> getTimeByCron(String cron) {
        return CronUtils.getExecuteTimeByCron((String)cron, (int)5);
    }

    @Override
    public List<JobResponseVO> getJobNameList(String keywords, Long jobId, String groupName) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName});
        queryWrapper.eq(Job::getNamespaceId, (Object)userSessionVO.getNamespaceId());
        if (StrUtil.isNotBlank((CharSequence)keywords)) {
            queryWrapper.like(Job::getJobName, (Object)(keywords.trim() + "%"));
        }
        if (StrUtil.isNotBlank((CharSequence)groupName)) {
            queryWrapper.eq(Job::getGroupName, (Object)groupName);
        }
        if (Objects.nonNull(jobId)) {
            queryWrapper.eq(Job::getId, (Object)jobId);
        }
        ((LambdaQueryWrapper)queryWrapper.eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByAsc(Job::getId);
        PageDTO pageDTO = new PageDTO(1L, 20L);
        PageDTO selectPage = (PageDTO)this.jobMapper.selectPage((IPage)pageDTO, (Wrapper)queryWrapper);
        return JobResponseVOConverter.INSTANCE.toJobResponseVOs(selectPage.getRecords());
    }

    @Override
    public boolean saveJob(JobRequestVO jobRequestVO) {
        Job job = this.updateJobResident(jobRequestVO);
        job.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(jobRequestVO.getGroupName() + jobRequestVO.getJobName())) % this.systemProperties.getBucketTotal()));
        job.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        job.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        return 1 == this.jobMapper.insert((Object)job);
    }

    @Override
    public boolean updateJob(JobRequestVO jobRequestVO) {
        Assert.notNull((Object)jobRequestVO.getId(), () -> new EasyRetryServerException("id \u4e0d\u80fd\u4e3a\u7a7a"));
        Job job = (Job)this.jobMapper.selectById((Serializable)jobRequestVO.getId());
        Assert.notNull((Object)job, () -> new EasyRetryServerException("\u66f4\u65b0\u5931\u8d25"));
        Job updateJob = this.updateJobResident(jobRequestVO);
        updateJob.setNamespaceId(job.getNamespaceId());
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            job.setNextTriggerAt(Long.valueOf(0L));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            updateJob.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, DateUtils.toNowMilli()));
        } else if (Objects.equals(job.getResident(), StatusEnum.YES.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.NO.getStatus())) {
            long time = Optional.ofNullable(ResidentTaskCache.get((Long)jobRequestVO.getId())).orElse(DateUtils.toNowMilli());
            updateJob.setNextTriggerAt(JobServiceImpl.calculateNextTriggerAt(jobRequestVO, time));
        } else if (Objects.equals(job.getResident(), StatusEnum.NO.getStatus()) && Objects.equals(updateJob.getResident(), StatusEnum.YES.getStatus())) {
            updateJob.setNextTriggerAt(Long.valueOf(DateUtils.toNowMilli()));
        }
        return 1 == this.jobMapper.updateById((Object)updateJob);
    }

    private static Long calculateNextTriggerAt(JobRequestVO jobRequestVO, Long time) {
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return 0L;
        }
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)jobRequestVO.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(jobRequestVO.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    @Override
    public Job updateJobResident(JobRequestVO jobRequestVO) {
        Job job = JobConverter.INSTANCE.toJob(jobRequestVO);
        job.setResident(StatusEnum.NO.getStatus());
        if (Objects.equals(jobRequestVO.getTriggerType(), SystemConstants.WORKFLOW_TRIGGER_TYPE)) {
            return job;
        }
        if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.FIXED.getType()) {
            if (Integer.parseInt(jobRequestVO.getTriggerInterval()) < 10) {
                job.setResident(StatusEnum.YES.getStatus());
            }
        } else if (jobRequestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType()) {
            if (CronUtils.getExecuteInterval((String)jobRequestVO.getTriggerInterval()) < 10000L) {
                job.setResident(StatusEnum.YES.getStatus());
            }
        } else {
            throw new EasyRetryServerException("\u672a\u77e5\u89e6\u53d1\u7c7b\u578b");
        }
        return job;
    }

    @Override
    public Boolean updateJobStatus(JobUpdateJobStatusRequestVO jobRequestVO) {
        Assert.notNull((Object)jobRequestVO.getId(), () -> new EasyRetryServerException("id \u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((1L == this.jobMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Job::getId, (Object)jobRequestVO.getId())) ? 1 : 0) != 0);
        Job job = new Job();
        job.setId(jobRequestVO.getId());
        job.setJobStatus(jobRequestVO.getJobStatus());
        return 1 == this.jobMapper.updateById((Object)job);
    }

    @Override
    public Boolean deleteJobById(Long id) {
        Job job = new Job();
        job.setId(id);
        job.setDeleted(StatusEnum.YES.getStatus());
        return 1 == this.jobMapper.updateById((Object)job);
    }

    @Override
    public boolean trigger(Long jobId) {
        Job job = (Job)this.jobMapper.selectById((Serializable)jobId);
        Assert.notNull((Object)job, () -> new EasyRetryServerException("job can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new EasyRetryServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{job.getGroupName()}));
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(job);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli());
        jobTaskPrepare.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_JOB.getType());
        this.terminalJobPrepareHandler.handler(jobTaskPrepare);
        return Boolean.TRUE;
    }

    @Override
    public List<JobResponseVO> getJobList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List jobs = this.jobMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Job::getId, Job::getJobName}).eq(Job::getNamespaceId, (Object)namespaceId)).eq(Job::getGroupName, (Object)groupName)).eq(Job::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Job::getCreateDt));
        List<JobResponseVO> jobResponseList = JobResponseVOConverter.INSTANCE.toJobResponseVOs(jobs);
        return jobResponseList;
    }

    public JobServiceImpl(SystemProperties systemProperties, JobMapper jobMapper, JobPrePareHandler terminalJobPrepareHandler, AccessTemplate accessTemplate) {
        this.systemProperties = systemProperties;
        this.jobMapper = jobMapper;
        this.terminalJobPrepareHandler = terminalJobPrepareHandler;
        this.accessTemplate = accessTemplate;
    }
}

