/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.JobNotifyConfigQueryVO;
import com.aizuda.easy.retry.server.web.model.request.JobNotifyConfigRequestVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.JobNotifyConfigResponseVO;
import com.aizuda.easy.retry.server.web.service.JobNotifyConfigService;
import com.aizuda.easy.retry.server.web.service.convert.JobNotifyConfigConverter;
import com.aizuda.easy.retry.server.web.service.convert.JobNotifyConfigResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.JobNotifyConfigQueryDO;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobNotifyConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobNotifyConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class JobNotifyConfigServiceImpl
implements JobNotifyConfigService {
    @Autowired
    private JobNotifyConfigMapper jobNotifyConfigMapper;

    @Override
    public PageResult<List<JobNotifyConfigResponseVO>> getJobNotifyConfigList(JobNotifyConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO();
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        JobNotifyConfigQueryDO queryDO = new JobNotifyConfigQueryDO();
        queryDO.setNamespaceId(userSessionVO.getNamespaceId());
        List<Object> groupNames = Lists.newArrayList();
        if (userSessionVO.isUser()) {
            groupNames = userSessionVO.getGroupNames();
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            if (!CollectionUtils.isEmpty((Collection)groupNames) && !groupNames.contains(queryVO.getGroupName())) {
                return new PageResult<List<JobNotifyConfigResponseVO>>(pageDTO, Lists.newArrayList());
            }
            groupNames = Lists.newArrayList((Object[])new String[]{queryVO.getGroupName()});
        }
        queryDO.setGroupNames((List)groupNames);
        if (Objects.nonNull(queryVO.getJobId())) {
            queryDO.setJobId(queryVO.getJobId());
        }
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"a.namespace_id", (Object)queryDO.getNamespaceId())).eq(queryDO.getJobId() != null, (Object)"a.job_id", (Object)queryDO.getJobId())).in(CollUtil.isNotEmpty((Collection)queryDO.getGroupNames()), (Object)"a.group_name", (Collection)queryDO.getGroupNames())).orderByDesc((Object)"a.id");
        List batchResponseDOList = this.jobNotifyConfigMapper.selectJobNotifyConfigList((IPage)pageDTO, (Wrapper)queryWrapper);
        return new PageResult<List<JobNotifyConfigResponseVO>>(pageDTO, JobNotifyConfigResponseVOConverter.INSTANCE.batchConvert(batchResponseDOList));
    }

    @Override
    public Boolean saveJobNotify(JobNotifyConfigRequestVO requestVO) {
        JobNotifyConfig jobNotifyConfig = JobNotifyConfigConverter.INSTANCE.toJobNotifyConfig(requestVO);
        jobNotifyConfig.setCreateDt(LocalDateTime.now());
        jobNotifyConfig.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        Assert.isTrue((1 == this.jobNotifyConfigMapper.insert((Object)jobNotifyConfig) ? 1 : 0) != 0, () -> new EasyRetryServerException("failed to insert jobNotifyConfig. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)jobNotifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateJobNotify(JobNotifyConfigRequestVO requestVO) {
        Assert.notNull((Object)requestVO.getId(), () -> new EasyRetryServerException("\u53c2\u6570\u5f02\u5e38"));
        JobNotifyConfig jobNotifyConfig = JobNotifyConfigConverter.INSTANCE.toJobNotifyConfig(requestVO);
        jobNotifyConfig.setNamespaceId(null);
        Assert.isTrue((1 == this.jobNotifyConfigMapper.updateById((Object)jobNotifyConfig) ? 1 : 0) != 0, () -> new EasyRetryServerException("failed to update jobNotifyConfig. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)jobNotifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public JobNotifyConfigResponseVO getJobNotifyConfigDetail(Long id) {
        JobNotifyConfig jobNotifyConfig = (JobNotifyConfig)this.jobNotifyConfigMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(JobNotifyConfig::getId, (Object)id));
        return JobNotifyConfigResponseVOConverter.INSTANCE.convert(jobNotifyConfig);
    }
}

