/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.constant.SystemConstants;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.dto.CallbackConfig;
import com.aizuda.easy.retry.server.common.dto.DecisionConfig;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.JobBatchQueryVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.JobBatchResponseVO;
import com.aizuda.easy.retry.server.web.service.JobBatchService;
import com.aizuda.easy.retry.server.web.service.convert.JobBatchResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.handler.JobHandler;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.JobBatchQueryDO;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class JobBatchServiceImpl
implements JobBatchService {
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final JobMapper jobMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final JobHandler jobHandler;

    @Override
    public PageResult<List<JobBatchResponseVO>> getJobBatchPage(JobBatchQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<Object> groupNames = Lists.newArrayList();
        if (userSessionVO.isUser()) {
            groupNames = userSessionVO.getGroupNames();
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            if (!CollectionUtils.isEmpty((Collection)groupNames) && !groupNames.contains(queryVO.getGroupName())) {
                return new PageResult<List<JobBatchResponseVO>>(pageDTO, Lists.newArrayList());
            }
            groupNames = Lists.newArrayList((Object[])new String[]{queryVO.getGroupName()});
        }
        JobBatchQueryDO queryDO = new JobBatchQueryDO();
        if (StrUtil.isNotBlank((CharSequence)queryVO.getJobName())) {
            queryDO.setJobName(queryVO.getJobName() + "%");
        }
        queryDO.setJobId(queryVO.getJobId());
        queryDO.setTaskBatchStatus(queryVO.getTaskBatchStatus());
        queryDO.setGroupNames(groupNames);
        queryDO.setNamespaceId(userSessionVO.getNamespaceId());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"a.namespace_id", (Object)queryDO.getNamespaceId())).eq((Object)"a.system_task_type", (Object)3)).eq(queryDO.getJobId() != null, (Object)"a.job_id", (Object)queryDO.getJobId())).in(CollUtil.isNotEmpty((Collection)queryDO.getGroupNames()), (Object)"a.group_name", (Collection)queryDO.getGroupNames())).eq(queryDO.getTaskBatchStatus() != null, (Object)"task_batch_status", (Object)queryDO.getTaskBatchStatus())).eq(StrUtil.isNotBlank((CharSequence)queryDO.getJobName()), (Object)"job_name", (Object)queryDO.getJobName())).eq((Object)"a.deleted", (Object)0)).orderByDesc((Object)"a.id");
        List batchResponseDOList = this.jobTaskBatchMapper.selectJobBatchPageList((IPage)pageDTO, (Wrapper)wrapper);
        List<JobBatchResponseVO> batchResponseVOList = JobBatchResponseVOConverter.INSTANCE.toJobBatchResponseVOs(batchResponseDOList);
        return new PageResult<List<JobBatchResponseVO>>(pageDTO, batchResponseVOList);
    }

    @Override
    public JobBatchResponseVO getJobBatchDetail(Long id) {
        JobTaskBatch jobTaskBatch = (JobTaskBatch)this.jobTaskBatchMapper.selectById((Serializable)id);
        if (Objects.isNull(jobTaskBatch)) {
            return null;
        }
        Job job = (Job)this.jobMapper.selectById((Serializable)jobTaskBatch.getJobId());
        JobBatchResponseVO jobBatchResponseVO = JobBatchResponseVOConverter.INSTANCE.toJobBatchResponseVO(jobTaskBatch, job);
        if (jobTaskBatch.getSystemTaskType().equals(SyetemTaskTypeEnum.WORKFLOW.getType())) {
            WorkflowNode workflowNode = (WorkflowNode)this.workflowNodeMapper.selectById((Serializable)jobTaskBatch.getWorkflowNodeId());
            jobBatchResponseVO.setNodeName(workflowNode.getNodeName());
            if (SystemConstants.CALLBACK_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponseVO.setCallback((CallbackConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), CallbackConfig.class));
                jobBatchResponseVO.setExecutionAt(jobTaskBatch.getCreateDt());
                return jobBatchResponseVO;
            }
            if (SystemConstants.DECISION_JOB_ID.equals(jobTaskBatch.getJobId())) {
                jobBatchResponseVO.setDecision((DecisionConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfig.class));
                jobBatchResponseVO.setExecutionAt(jobTaskBatch.getCreateDt());
                return jobBatchResponseVO;
            }
        }
        return jobBatchResponseVO;
    }

    @Override
    public boolean stop(Long taskBatchId) {
        return this.jobHandler.stop(taskBatchId);
    }

    @Override
    @Transactional
    public Boolean retry(Long taskBatchId) {
        return this.jobHandler.retry(taskBatchId);
    }

    public JobBatchServiceImpl(JobTaskBatchMapper jobTaskBatchMapper, JobMapper jobMapper, WorkflowNodeMapper workflowNodeMapper, JobHandler jobHandler) {
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.jobMapper = jobMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.jobHandler = jobHandler;
    }
}

