/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.enums.NodeTypeEnum;
import com.aizuda.easy.retry.common.core.model.Result;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.core.util.NetUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.dto.DistributeInstance;
import com.aizuda.easy.retry.server.common.dto.ServerNodeExtAttrs;
import com.aizuda.easy.retry.server.common.enums.DashboardLineEnum;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.easy.retry.server.common.enums.SystemModeEnum;
import com.aizuda.easy.retry.server.common.register.ServerRegister;
import com.aizuda.easy.retry.server.web.model.base.BaseQueryVO;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.enums.DateTypeEnum;
import com.aizuda.easy.retry.server.web.model.request.ServerNodeQueryVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.DashboardCardResponseVO;
import com.aizuda.easy.retry.server.web.model.response.DashboardLineResponseVO;
import com.aizuda.easy.retry.server.web.model.response.DashboardRetryLineResponseVO;
import com.aizuda.easy.retry.server.web.model.response.ServerNodeResponseVO;
import com.aizuda.easy.retry.server.web.service.DashBoardService;
import com.aizuda.easy.retry.server.web.service.convert.DispatchQuantityResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.convert.JobSummaryResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.convert.RetrySummaryResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.convert.SceneQuantityRankResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.convert.ServerNodeResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.enums.DbTypeEnum;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.ActivePodQuantityResponseDO;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.DashboardCardResponseDO;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetrySummaryMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobSummary;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetrySummary;
import com.aizuda.easy.retry.template.datasource.persistence.po.SceneConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.ServerNode;
import com.aizuda.easy.retry.template.datasource.utils.DbUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DashBoardServiceImpl
implements DashBoardService {
    private static final Logger log = LoggerFactory.getLogger(DashBoardServiceImpl.class);
    private static final String DASHBOARD_CONSUMER_BUCKET = "/dashboard/consumer/bucket";
    private final ServerNodeMapper serverNodeMapper;
    private final RestTemplate restTemplate;
    private final JobSummaryMapper jobSummaryMapper;
    private final RetrySummaryMapper retrySummaryMapper;

    @Override
    public DashboardCardResponseVO taskRetryJob() {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ArrayList groupNames = userSessionVO.isUser() ? userSessionVO.getGroupNames() : new ArrayList();
        DashboardCardResponseVO dashboardCardResponseVO = new DashboardCardResponseVO();
        LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames);
        DashboardCardResponseDO.RetryTask retryTaskDO = this.retrySummaryMapper.retryTask((Wrapper)wrapper2);
        DashboardCardResponseVO.RetryTask retryTaskVO = RetrySummaryResponseVOConverter.INSTANCE.toRetryTask(retryTaskDO);
        dashboardCardResponseVO.setRetryTask(retryTaskVO);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.JOB.getType())).eq(JobSummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames);
        DashboardCardResponseDO.JobTask jobTaskDO = this.jobSummaryMapper.toJobTask((Wrapper)wrapper);
        DashboardCardResponseVO.JobTask jobTaskVO = JobSummaryResponseVOConverter.INSTANCE.toTaskJob(jobTaskDO);
        dashboardCardResponseVO.setJobTask(jobTaskVO);
        LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType())).eq(JobSummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames);
        DashboardCardResponseDO.JobTask workFlowTaskDO = this.jobSummaryMapper.toJobTask((Wrapper)wrapper1);
        DashboardCardResponseVO.WorkFlowTask workFlowTaskVO = JobSummaryResponseVOConverter.INSTANCE.toWorkFlowTask(workFlowTaskDO);
        dashboardCardResponseVO.setWorkFlowTask(workFlowTaskVO);
        HashMap<LocalDateTime, DashboardCardResponseVO.RetryTaskBar> retryTaskBarMap = new HashMap<LocalDateTime, DashboardCardResponseVO.RetryTaskBar>();
        for (int i2 = 0; i2 < 7; ++i2) {
            DashboardCardResponseVO.RetryTaskBar retryTaskBar = new DashboardCardResponseVO.RetryTaskBar().setX(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).plusDays(-i2).toLocalDate().toString()).setTaskTotal(0L);
            retryTaskBarMap.put(LocalDateTime.of(LocalDate.now(), LocalTime.MIN).plusDays(-i2), retryTaskBar);
        }
        LambdaQueryWrapper wrapper3 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySummary::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames)).orderByDesc(RetrySummary::getId);
        List retryTaskList = this.retrySummaryMapper.retryTaskBarList((Wrapper)wrapper3);
        Map<LocalDateTime, LongSummaryStatistics> summaryStatisticsMap = retryTaskList.stream().collect(Collectors.groupingBy(DashboardCardResponseDO.RetryTask::getTriggerAt, Collectors.summarizingLong(i -> i.getMaxCountNum() + i.getRunningNum() + i.getSuspendNum() + i.getFinishNum())));
        for (Map.Entry<LocalDateTime, LongSummaryStatistics> map : summaryStatisticsMap.entrySet()) {
            if (!retryTaskBarMap.containsKey(LocalDateTime.of(map.getKey().toLocalDate(), LocalTime.MIN))) continue;
            DashboardCardResponseVO.RetryTaskBar retryTaskBar = (DashboardCardResponseVO.RetryTaskBar)retryTaskBarMap.get(LocalDateTime.of(map.getKey().toLocalDate(), LocalTime.MIN));
            retryTaskBar.setX(map.getKey().toLocalDate().toString()).setTaskTotal(map.getValue().getSum());
        }
        dashboardCardResponseVO.setRetryTaskBarList(new ArrayList<DashboardCardResponseVO.RetryTaskBar>(retryTaskBarMap.values()));
        LambdaQueryWrapper wrapper4 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ServerNode::getNamespaceId, (Collection)Lists.newArrayList((Object[])new String[]{userSessionVO.getNamespaceId(), "DEFAULT_SERVER_NAMESPACE_ID"}))).groupBy(ServerNode::getNodeType);
        List activePodQuantityDO = this.serverNodeMapper.countActivePod((Wrapper)wrapper4);
        Map<Integer, Long> map = activePodQuantityDO.stream().collect(Collectors.toMap(ActivePodQuantityResponseDO::getNodeType, ActivePodQuantityResponseDO::getTotal));
        Long clientTotal = map.getOrDefault(NodeTypeEnum.CLIENT.getType(), 0L);
        Long serverTotal = map.getOrDefault(NodeTypeEnum.SERVER.getType(), 0L);
        dashboardCardResponseVO.getOnLineService().setServerTotal(serverTotal);
        dashboardCardResponseVO.getOnLineService().setClientTotal(clientTotal);
        dashboardCardResponseVO.getOnLineService().setTotal(clientTotal + serverTotal);
        return dashboardCardResponseVO;
    }

    @Override
    public DashboardRetryLineResponseVO retryLineList(BaseQueryVO baseQueryVO, String groupName, String type, String startTime, String endTime) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ArrayList groupNames = userSessionVO.isUser() ? userSessionVO.getGroupNames() : new ArrayList();
        DashboardRetryLineResponseVO dashboardRetryLineResponseVO = new DashboardRetryLineResponseVO();
        Page pager = new Page((long)baseQueryVO.getPage(), (long)baseQueryVO.getSize());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SceneConfig::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), SceneConfig::getGroupName, groupNames);
        if (DbTypeEnum.SQLSERVER == DbUtils.getDbType()) {
            pager.setSearchCount(false);
            pager.setTotal(this.retrySummaryMapper.countRetryTask((Wrapper)wrapper));
        }
        IPage page = this.retrySummaryMapper.retryTaskList((Wrapper)wrapper, pager);
        List<DashboardRetryLineResponseVO.Task> taskList = JobSummaryResponseVOConverter.INSTANCE.toDashboardRetryLineResponseVO(page.getRecords());
        PageResult<List<DashboardRetryLineResponseVO.Task>> pageResult = new PageResult<List<DashboardRetryLineResponseVO.Task>>(new PageDTO(pager.getCurrent(), pager.getSize(), pager.getTotal()), taskList);
        dashboardRetryLineResponseVO.setTaskList(pageResult);
        DateTypeEnum dateTypeEnum = DateTypeEnum.valueOf(type);
        LocalDateTime startDateTime = dateTypeEnum.getStartTime().apply(StrUtil.isNotBlank((CharSequence)startTime) ? LocalDateTime.parse(startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
        LocalDateTime endDateTime = dateTypeEnum.getEndTime().apply(StrUtil.isNotBlank((CharSequence)endTime) ? LocalDateTime.parse(endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
        LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)groupName), RetrySummary::getGroupName, (Object)groupName)).eq(RetrySummary::getNamespaceId, (Object)namespaceId)).between(RetrySummary::getTriggerAt, (Object)startDateTime, (Object)endDateTime);
        List dashboardRetryLinkeResponseDOList = this.retrySummaryMapper.retryLineList(DashboardLineEnum.dateFormat((String)type), (Wrapper)wrapper1);
        List<DashboardLineResponseVO> dashboardLineResponseVOList = DispatchQuantityResponseVOConverter.INSTANCE.toDashboardLineResponseVO(dashboardRetryLinkeResponseDOList);
        dateTypeEnum.getConsumer().accept(dashboardLineResponseVOList);
        dashboardLineResponseVOList.sort(Comparator.comparing(a -> a.getCreateDt()));
        dashboardRetryLineResponseVO.setDashboardLineResponseDOList(dashboardLineResponseVOList);
        LambdaQueryWrapper wrapper2 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), RetrySummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)groupName), RetrySummary::getGroupName, groupNames)).eq(RetrySummary::getNamespaceId, (Object)namespaceId)).ge(RetrySummary::getTriggerAt, (Object)startDateTime)).le(RetrySummary::getTriggerAt, (Object)endDateTime)).groupBy(RetrySummary::getNamespaceId, new SFunction[]{RetrySummary::getGroupName, RetrySummary::getSceneName});
        List rankList = this.retrySummaryMapper.dashboardRank((Wrapper)wrapper2);
        List<DashboardRetryLineResponseVO.Rank> ranks = SceneQuantityRankResponseVOConverter.INSTANCE.toDashboardRetryLineResponseVORank(rankList);
        dashboardRetryLineResponseVO.setRankList(ranks);
        return dashboardRetryLineResponseVO;
    }

    @Override
    public DashboardRetryLineResponseVO jobLineList(BaseQueryVO baseQueryVO, String mode, String groupName, String type, String startTime, String endTime) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        ArrayList groupNames = userSessionVO.isUser() ? userSessionVO.getGroupNames() : new ArrayList();
        DashboardRetryLineResponseVO dashboardRetryLineResponseVO = new DashboardRetryLineResponseVO();
        Page pager = new Page((long)baseQueryVO.getPage(), (long)baseQueryVO.getSize());
        Integer systemTaskType = SystemModeEnum.JOB.name().equals(mode) ? SyetemTaskTypeEnum.JOB.getType() : SyetemTaskTypeEnum.WORKFLOW.getType();
        LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Job::getNamespaceId, (Object)namespaceId)).in(CollUtil.isNotEmpty(groupNames), Job::getGroupName, groupNames);
        if (DbTypeEnum.SQLSERVER == DbUtils.getDbType()) {
            pager.setSearchCount(false);
            pager.setTotal(this.jobSummaryMapper.countJobTask((Wrapper)wrapper1));
        }
        IPage page = this.jobSummaryMapper.jobTaskList((Wrapper)wrapper1, pager);
        List<DashboardRetryLineResponseVO.Task> taskList = JobSummaryResponseVOConverter.INSTANCE.toDashboardRetryLineResponseVO(page.getRecords());
        PageResult<List<DashboardRetryLineResponseVO.Task>> pageResult = new PageResult<List<DashboardRetryLineResponseVO.Task>>(new PageDTO(pager.getCurrent(), pager.getSize(), pager.getTotal()), taskList);
        dashboardRetryLineResponseVO.setTaskList(pageResult);
        DateTypeEnum dateTypeEnum = DateTypeEnum.valueOf(type);
        LocalDateTime startDateTime = dateTypeEnum.getStartTime().apply(StrUtil.isNotBlank((CharSequence)startTime) ? LocalDateTime.parse(startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
        LocalDateTime endDateTime = dateTypeEnum.getEndTime().apply(StrUtil.isNotBlank((CharSequence)endTime) ? LocalDateTime.parse(endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")) : null);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)groupName), JobSummary::getGroupName, (Object)groupName)).eq(JobSummary::getSystemTaskType, (Object)systemTaskType)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).between(JobSummary::getTriggerAt, (Object)startDateTime, (Object)endDateTime);
        List dashboardLineResponseDOList = this.jobSummaryMapper.jobLineList(DashboardLineEnum.dateFormat((String)type), (Wrapper)queryWrapper);
        List<DashboardLineResponseVO> dashboardLineResponseVOList = DispatchQuantityResponseVOConverter.INSTANCE.toDashboardLineResponseVO(dashboardLineResponseDOList);
        dateTypeEnum.getConsumer().accept(dashboardLineResponseVOList);
        dashboardLineResponseVOList.sort(Comparator.comparing(a -> a.getCreateDt()));
        dashboardRetryLineResponseVO.setDashboardLineResponseDOList(dashboardLineResponseVOList);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CollUtil.isNotEmpty(groupNames), JobSummary::getGroupName, groupNames)).eq(StrUtil.isNotBlank((CharSequence)groupName), JobSummary::getGroupName, (Object)groupName)).ge(JobSummary::getTriggerAt, (Object)startDateTime)).le(JobSummary::getTriggerAt, (Object)endDateTime)).eq(JobSummary::getSystemTaskType, (Object)systemTaskType)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).groupBy(JobSummary::getNamespaceId, new SFunction[]{JobSummary::getGroupName, JobSummary::getBusinessId});
        List rankList = this.jobSummaryMapper.dashboardRank(systemTaskType, (Wrapper)wrapper);
        List<DashboardRetryLineResponseVO.Rank> ranks = SceneQuantityRankResponseVOConverter.INSTANCE.toDashboardRetryLineResponseVORank(rankList);
        dashboardRetryLineResponseVO.setRankList(ranks);
        return dashboardRetryLineResponseVO;
    }

    @Override
    public PageResult<List<ServerNodeResponseVO>> pods(ServerNodeQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper serverNodeLambdaQueryWrapper = new LambdaQueryWrapper();
        serverNodeLambdaQueryWrapper.in(ServerNode::getNamespaceId, (Collection)Lists.newArrayList((Object[])new String[]{UserSessionUtils.currentUserSession().getNamespaceId(), "DEFAULT_SERVER_NAMESPACE_ID"}));
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            serverNodeLambdaQueryWrapper.eq(ServerNode::getGroupName, (Object)queryVO.getGroupName());
        }
        serverNodeLambdaQueryWrapper.ge(ServerNode::getExpireAt, (Object)LocalDateTime.now().minusSeconds(40L));
        PageDTO serverNodePageDTO = (PageDTO)this.serverNodeMapper.selectPage((IPage)pageDTO, (Wrapper)serverNodeLambdaQueryWrapper.orderByDesc(ServerNode::getNodeType));
        List<ServerNodeResponseVO> serverNodeResponseVOS = ServerNodeResponseVOConverter.INSTANCE.toServerNodeResponseVO(serverNodePageDTO.getRecords());
        for (ServerNodeResponseVO serverNodeResponseVO : serverNodeResponseVOS) {
            if (NodeTypeEnum.CLIENT.getType().equals(serverNodeResponseVO.getNodeType())) continue;
            if (ServerRegister.CURRENT_CID.equals(serverNodeResponseVO.getHostId())) {
                serverNodeResponseVO.setConsumerBuckets(DistributeInstance.INSTANCE.getConsumerBucket());
                continue;
            }
            if (StringUtils.isBlank((CharSequence)serverNodeResponseVO.getExtAttrs())) continue;
            ServerNodeExtAttrs serverNodeExtAttrs = (ServerNodeExtAttrs)JsonUtil.parseObject((String)serverNodeResponseVO.getExtAttrs(), ServerNodeExtAttrs.class);
            try {
                String url = NetUtil.getUrl((String)serverNodeResponseVO.getHostIp(), (int)serverNodeExtAttrs.getWebPort(), (String)serverNodeResponseVO.getContextPath());
                Result result = (Result)this.restTemplate.getForObject(url.concat(DASHBOARD_CONSUMER_BUCKET), Result.class, new Object[0]);
                List data = (List)result.getData();
                if (CollectionUtils.isEmpty((Collection)data)) continue;
                serverNodeResponseVO.setConsumerBuckets(data.stream().sorted(Integer::compareTo).collect(Collectors.toCollection(LinkedHashSet::new)));
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error("Failed to retrieve consumer group for node [{}:{}].", new Object[]{serverNodeResponseVO.getHostIp(), serverNodeExtAttrs.getWebPort()});
            }
        }
        return new PageResult<List<ServerNodeResponseVO>>(serverNodePageDTO, serverNodeResponseVOS);
    }

    public DashBoardServiceImpl(ServerNodeMapper serverNodeMapper, RestTemplate restTemplate, JobSummaryMapper jobSummaryMapper, RetrySummaryMapper retrySummaryMapper) {
        this.serverNodeMapper = serverNodeMapper;
        this.restTemplate = restTemplate;
        this.jobSummaryMapper = jobSummaryMapper;
        this.retrySummaryMapper = retrySummaryMapper;
    }
}

