/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.convert;

import com.aizuda.easy.retry.server.web.model.request.WorkflowRequestVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowBatchResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowResponseVO;
import com.aizuda.easy.retry.server.web.service.convert.WorkflowConverter;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.easy.retry.template.datasource.persistence.po.Workflow;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowTaskBatch;
import java.util.ArrayList;
import java.util.List;

public class WorkflowConverterImpl
implements WorkflowConverter {
    @Override
    public Workflow toWorkflow(WorkflowRequestVO workflowRequestVO) {
        if (workflowRequestVO == null) {
            return null;
        }
        Workflow workflow = new Workflow();
        workflow.setId(workflowRequestVO.getId());
        workflow.setWorkflowName(workflowRequestVO.getWorkflowName());
        workflow.setGroupName(workflowRequestVO.getGroupName());
        workflow.setTriggerType(workflowRequestVO.getTriggerType());
        workflow.setBlockStrategy(workflowRequestVO.getBlockStrategy());
        workflow.setTriggerInterval(workflowRequestVO.getTriggerInterval());
        workflow.setExecutorTimeout(workflowRequestVO.getExecutorTimeout());
        workflow.setWorkflowStatus(workflowRequestVO.getWorkflowStatus());
        workflow.setDescription(workflowRequestVO.getDescription());
        return workflow;
    }

    @Override
    public WorkflowNode toWorkflowNode(WorkflowRequestVO.NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            return null;
        }
        WorkflowNode workflowNode = new WorkflowNode();
        workflowNode.setNodeName(nodeInfo.getNodeName());
        workflowNode.setFailStrategy(nodeInfo.getFailStrategy());
        workflowNode.setPriorityLevel(nodeInfo.getPriorityLevel());
        workflowNode.setWorkflowNodeStatus(nodeInfo.getWorkflowNodeStatus());
        return workflowNode;
    }

    @Override
    public WorkflowDetailResponseVO toWorkflowDetailResponseVO(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowDetailResponseVO workflowDetailResponseVO = new WorkflowDetailResponseVO();
        workflowDetailResponseVO.setId(workflow.getId());
        workflowDetailResponseVO.setWorkflowName(workflow.getWorkflowName());
        workflowDetailResponseVO.setGroupName(workflow.getGroupName());
        workflowDetailResponseVO.setTriggerType(workflow.getTriggerType());
        workflowDetailResponseVO.setBlockStrategy(workflow.getBlockStrategy());
        workflowDetailResponseVO.setTriggerInterval(workflow.getTriggerInterval());
        workflowDetailResponseVO.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowDetailResponseVO.setWorkflowStatus(workflow.getWorkflowStatus());
        return workflowDetailResponseVO;
    }

    @Override
    public List<WorkflowDetailResponseVO.NodeInfo> toNodeInfo(List<WorkflowNode> workflowNodes) {
        if (workflowNodes == null) {
            return null;
        }
        ArrayList<WorkflowDetailResponseVO.NodeInfo> list = new ArrayList<WorkflowDetailResponseVO.NodeInfo>(workflowNodes.size());
        for (WorkflowNode workflowNode : workflowNodes) {
            list.add(this.toNodeInfo(workflowNode));
        }
        return list;
    }

    @Override
    public WorkflowDetailResponseVO.NodeInfo toNodeInfo(WorkflowNode workflowNode) {
        if (workflowNode == null) {
            return null;
        }
        WorkflowDetailResponseVO.NodeInfo nodeInfo = new WorkflowDetailResponseVO.NodeInfo();
        nodeInfo.setId(workflowNode.getId());
        nodeInfo.setNodeType(workflowNode.getNodeType());
        nodeInfo.setNodeName(workflowNode.getNodeName());
        nodeInfo.setPriorityLevel(workflowNode.getPriorityLevel());
        nodeInfo.setWorkflowNodeStatus(workflowNode.getWorkflowNodeStatus());
        nodeInfo.setFailStrategy(workflowNode.getFailStrategy());
        nodeInfo.setDecision(WorkflowConverter.parseDecisionConfig(workflowNode));
        nodeInfo.setCallback(WorkflowConverter.parseCallbackConfig(workflowNode));
        nodeInfo.setJobTask(WorkflowConverter.parseJobTaskConfig(workflowNode));
        return nodeInfo;
    }

    @Override
    public List<WorkflowResponseVO> toWorkflowResponseVO(List<Workflow> workflowList) {
        if (workflowList == null) {
            return null;
        }
        ArrayList<WorkflowResponseVO> list = new ArrayList<WorkflowResponseVO>(workflowList.size());
        for (Workflow workflow : workflowList) {
            list.add(this.toWorkflowResponseVO(workflow));
        }
        return list;
    }

    @Override
    public WorkflowResponseVO toWorkflowResponseVO(Workflow workflow) {
        if (workflow == null) {
            return null;
        }
        WorkflowResponseVO workflowResponseVO = new WorkflowResponseVO();
        workflowResponseVO.setId(workflow.getId());
        workflowResponseVO.setWorkflowName(workflow.getWorkflowName());
        workflowResponseVO.setGroupName(workflow.getGroupName());
        workflowResponseVO.setTriggerType(workflow.getTriggerType());
        workflowResponseVO.setTriggerInterval(workflow.getTriggerInterval());
        workflowResponseVO.setExecutorTimeout(workflow.getExecutorTimeout());
        workflowResponseVO.setWorkflowStatus(workflow.getWorkflowStatus());
        workflowResponseVO.setCreateDt(workflow.getCreateDt());
        workflowResponseVO.setUpdateDt(workflow.getUpdateDt());
        workflowResponseVO.setNextTriggerAt(WorkflowConverter.toLocalDateTime(workflow.getNextTriggerAt()));
        return workflowResponseVO;
    }

    @Override
    public List<WorkflowBatchResponseVO> toWorkflowBatchResponseVO(List<WorkflowBatchResponseDO> workflowBatchResponseList) {
        if (workflowBatchResponseList == null) {
            return null;
        }
        ArrayList<WorkflowBatchResponseVO> list = new ArrayList<WorkflowBatchResponseVO>(workflowBatchResponseList.size());
        for (WorkflowBatchResponseDO workflowBatchResponseDO : workflowBatchResponseList) {
            list.add(this.workflowBatchResponseDOToWorkflowBatchResponseVO(workflowBatchResponseDO));
        }
        return list;
    }

    @Override
    public WorkflowBatchResponseVO toWorkflowBatchResponseVO(WorkflowTaskBatch workflowTaskBatch, Workflow workflow) {
        if (workflowTaskBatch == null && workflow == null) {
            return null;
        }
        WorkflowBatchResponseVO workflowBatchResponseVO = new WorkflowBatchResponseVO();
        if (workflowTaskBatch != null) {
            workflowBatchResponseVO.setGroupName(workflowTaskBatch.getGroupName());
            workflowBatchResponseVO.setId(workflowTaskBatch.getId());
            workflowBatchResponseVO.setCreateDt(workflowTaskBatch.getCreateDt());
            workflowBatchResponseVO.setWorkflowId(workflowTaskBatch.getWorkflowId());
            workflowBatchResponseVO.setTaskBatchStatus(workflowTaskBatch.getTaskBatchStatus());
            workflowBatchResponseVO.setOperationReason(workflowTaskBatch.getOperationReason());
        }
        if (workflow != null) {
            workflowBatchResponseVO.setWorkflowName(workflow.getWorkflowName());
        }
        workflowBatchResponseVO.setExecutionAt(WorkflowConverter.toLocalDateTime(workflowTaskBatch.getExecutionAt()));
        return workflowBatchResponseVO;
    }

    protected WorkflowBatchResponseVO workflowBatchResponseDOToWorkflowBatchResponseVO(WorkflowBatchResponseDO workflowBatchResponseDO) {
        if (workflowBatchResponseDO == null) {
            return null;
        }
        WorkflowBatchResponseVO workflowBatchResponseVO = new WorkflowBatchResponseVO();
        workflowBatchResponseVO.setId(workflowBatchResponseDO.getId());
        workflowBatchResponseVO.setGroupName(workflowBatchResponseDO.getGroupName());
        workflowBatchResponseVO.setWorkflowId(workflowBatchResponseDO.getWorkflowId());
        workflowBatchResponseVO.setWorkflowName(workflowBatchResponseDO.getWorkflowName());
        workflowBatchResponseVO.setTaskBatchStatus(workflowBatchResponseDO.getTaskBatchStatus());
        workflowBatchResponseVO.setOperationReason(workflowBatchResponseDO.getOperationReason());
        workflowBatchResponseVO.setExecutionAt(WorkflowConverter.toLocalDateTime(workflowBatchResponseDO.getExecutionAt()));
        workflowBatchResponseVO.setCreateDt(workflowBatchResponseDO.getCreateDt());
        return workflowBatchResponseVO;
    }
}

