/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.convert;

import com.aizuda.easy.retry.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.dto.CallbackConfig;
import com.aizuda.easy.retry.server.common.dto.DecisionConfig;
import com.aizuda.easy.retry.server.common.dto.JobTaskConfig;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.web.model.request.WorkflowRequestVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowBatchResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowResponseVO;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.WorkflowBatchResponseDO;
import com.aizuda.easy.retry.template.datasource.persistence.po.Workflow;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowTaskBatch;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper
public interface WorkflowConverter {
    public static final WorkflowConverter INSTANCE = (WorkflowConverter)Mappers.getMapper(WorkflowConverter.class);

    public Workflow toWorkflow(WorkflowRequestVO var1);

    public WorkflowNode toWorkflowNode(WorkflowRequestVO.NodeInfo var1);

    public WorkflowDetailResponseVO toWorkflowDetailResponseVO(Workflow var1);

    public List<WorkflowDetailResponseVO.NodeInfo> toNodeInfo(List<WorkflowNode> var1);

    @Mappings(value={@Mapping(target="decision", expression="java(WorkflowConverter.parseDecisionConfig(workflowNode))"), @Mapping(target="callback", expression="java(WorkflowConverter.parseCallbackConfig(workflowNode))"), @Mapping(target="jobTask", expression="java(WorkflowConverter.parseJobTaskConfig(workflowNode))")})
    public WorkflowDetailResponseVO.NodeInfo toNodeInfo(WorkflowNode var1);

    public List<WorkflowResponseVO> toWorkflowResponseVO(List<Workflow> var1);

    @Mappings(value={@Mapping(target="nextTriggerAt", expression="java(WorkflowConverter.toLocalDateTime(workflow.getNextTriggerAt()))")})
    public WorkflowResponseVO toWorkflowResponseVO(Workflow var1);

    public List<WorkflowBatchResponseVO> toWorkflowBatchResponseVO(List<WorkflowBatchResponseDO> var1);

    @Mappings(value={@Mapping(source="workflowTaskBatch.groupName", target="groupName"), @Mapping(source="workflowTaskBatch.id", target="id"), @Mapping(source="workflowTaskBatch.createDt", target="createDt"), @Mapping(target="executionAt", expression="java(WorkflowConverter.toLocalDateTime(workflowTaskBatch.getExecutionAt()))")})
    public WorkflowBatchResponseVO toWorkflowBatchResponseVO(WorkflowTaskBatch var1, Workflow var2);

    public static LocalDateTime toLocalDateTime(Long nextTriggerAt) {
        if (Objects.isNull(nextTriggerAt) || nextTriggerAt == 0L) {
            return null;
        }
        return DateUtils.toLocalDateTime((long)nextTriggerAt);
    }

    public static DecisionConfig parseDecisionConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.DECISION.getType() == workflowNode.getNodeType().intValue()) {
            return (DecisionConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), DecisionConfig.class);
        }
        return null;
    }

    public static CallbackConfig parseCallbackConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.CALLBACK.getType() == workflowNode.getNodeType().intValue()) {
            return (CallbackConfig)JsonUtil.parseObject((String)workflowNode.getNodeInfo(), CallbackConfig.class);
        }
        return null;
    }

    public static JobTaskConfig parseJobTaskConfig(WorkflowNode workflowNode) {
        if (WorkflowNodeTypeEnum.JOB_TASK.getType() == workflowNode.getNodeType().intValue()) {
            JobTaskConfig jobTaskConfig = new JobTaskConfig();
            jobTaskConfig.setJobId(workflowNode.getJobId());
            return jobTaskConfig;
        }
        return null;
    }
}

