/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.controller;

import cn.hutool.core.lang.Pair;
import com.aizuda.easy.retry.server.common.dto.DecisionConfig;
import com.aizuda.easy.retry.server.web.annotation.LoginRequired;
import com.aizuda.easy.retry.server.web.annotation.RoleEnum;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.WorkflowQueryVO;
import com.aizuda.easy.retry.server.web.model.request.WorkflowRequestVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowResponseVO;
import com.aizuda.easy.retry.server.web.service.WorkflowService;
import java.io.IOException;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/workflow"})
public class WorkflowController {
    private final WorkflowService workflowService;

    @PostMapping
    @LoginRequired(role=RoleEnum.USER)
    public Boolean saveWorkflow(@RequestBody @Validated WorkflowRequestVO workflowRequestVO) {
        return this.workflowService.saveWorkflow(workflowRequestVO);
    }

    @GetMapping(value={"/page/list"})
    @LoginRequired(role=RoleEnum.USER)
    public PageResult<List<WorkflowResponseVO>> listPage(WorkflowQueryVO queryVO) {
        return this.workflowService.listPage(queryVO);
    }

    @PutMapping
    @LoginRequired(role=RoleEnum.USER)
    public Boolean updateWorkflow(@RequestBody @Validated WorkflowRequestVO workflowRequestVO) {
        return this.workflowService.updateWorkflow(workflowRequestVO);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired(role=RoleEnum.USER)
    public WorkflowDetailResponseVO getWorkflowDetail(@PathVariable(value="id") Long id) throws IOException {
        return this.workflowService.getWorkflowDetail(id);
    }

    @PutMapping(value={"/update/status/{id}"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean updateStatus(@PathVariable(value="id") Long id) {
        return this.workflowService.updateStatus(id);
    }

    @DeleteMapping(value={"/{id}"})
    @LoginRequired(role=RoleEnum.ADMIN)
    public Boolean deleteById(@PathVariable(value="id") Long id) {
        return this.workflowService.deleteById(id);
    }

    @PostMapping(value={"/trigger/{id}"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean trigger(@PathVariable(value="id") Long id) {
        return this.workflowService.trigger(id);
    }

    @GetMapping(value={"/workflow-name/list"})
    @LoginRequired(role=RoleEnum.USER)
    public List<WorkflowResponseVO> getWorkflowNameList(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="workflowId", required=false) Long workflowId) {
        return this.workflowService.getWorkflowNameList(keywords, workflowId);
    }

    @PostMapping(value={"/check-node-expression"})
    @LoginRequired(role=RoleEnum.USER)
    public Pair<Integer, String> checkNodeExpression(@RequestBody DecisionConfig decisionConfig) {
        return this.workflowService.checkNodeExpression(decisionConfig);
    }

    public WorkflowController(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

