/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.controller;

import com.aizuda.easy.retry.server.web.annotation.LoginRequired;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.JobNotifyConfigQueryVO;
import com.aizuda.easy.retry.server.web.model.request.JobNotifyConfigRequestVO;
import com.aizuda.easy.retry.server.web.model.response.JobNotifyConfigResponseVO;
import com.aizuda.easy.retry.server.web.service.JobNotifyConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job/notify/config"})
public class JobNotifyConfigController {
    @Autowired
    private JobNotifyConfigService jobNotifyConfigService;

    @LoginRequired
    @GetMapping(value={"/page/list"})
    public PageResult<List<JobNotifyConfigResponseVO>> getNotifyConfigList(JobNotifyConfigQueryVO queryVO) {
        return this.jobNotifyConfigService.getJobNotifyConfigList(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public JobNotifyConfigResponseVO getJobNotifyConfigDetail(@PathVariable(value="id") Long id) {
        return this.jobNotifyConfigService.getJobNotifyConfigDetail(id);
    }

    @LoginRequired
    @PostMapping
    public Boolean saveNotify(@RequestBody @Validated JobNotifyConfigRequestVO requestVO) {
        return this.jobNotifyConfigService.saveJobNotify(requestVO);
    }

    @LoginRequired
    @PutMapping
    public Boolean updateNotify(@RequestBody @Validated JobNotifyConfigRequestVO requestVO) {
        return this.jobNotifyConfigService.updateJobNotify(requestVO);
    }
}

