/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.constant.SystemConstants;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.common.core.expression.ExpressionEngine;
import com.aizuda.easy.retry.common.core.expression.ExpressionFactory;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.WaitStrategy;
import com.aizuda.easy.retry.server.common.config.SystemProperties;
import com.aizuda.easy.retry.server.common.dto.DecisionConfig;
import com.aizuda.easy.retry.server.common.dto.JobTaskConfig;
import com.aizuda.easy.retry.server.common.enums.ExpressionTypeEnum;
import com.aizuda.easy.retry.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.strategy.WaitStrategies;
import com.aizuda.easy.retry.server.common.util.CronUtils;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.common.util.GraphUtils;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.support.WorkflowPrePareHandler;
import com.aizuda.easy.retry.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.expression.ExpressionInvocationHandler;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.request.WorkflowQueryVO;
import com.aizuda.easy.retry.server.web.model.request.WorkflowRequestVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowResponseVO;
import com.aizuda.easy.retry.server.web.service.WorkflowService;
import com.aizuda.easy.retry.server.web.service.convert.WorkflowConverter;
import com.aizuda.easy.retry.server.web.service.handler.WorkflowHandler;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.aizuda.easy.retry.template.datasource.persistence.po.Workflow;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkflowServiceImpl
implements WorkflowService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private final WorkflowMapper workflowMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final SystemProperties systemProperties;
    private final WorkflowHandler workflowHandler;
    @Lazy
    private final WorkflowPrePareHandler terminalWorkflowPrepareHandler;
    private final JobMapper jobMapper;
    private final AccessTemplate accessTemplate;

    @Override
    @Transactional
    public boolean saveWorkflow(WorkflowRequestVO workflowRequestVO) {
        log.info("\u4fdd\u5b58\u5de5\u4f5c\u6d41\u4fe1\u606f\uff1a{}", (Object)JsonUtil.toJsonString((Object)workflowRequestVO));
        MutableGraph<Long> graph = this.createGraph();
        graph.addNode((Object)SystemConstants.ROOT);
        Workflow workflow = WorkflowConverter.INSTANCE.toWorkflow(workflowRequestVO);
        workflow.setVersion(Integer.valueOf(1));
        workflow.setNextTriggerAt(WorkflowServiceImpl.calculateNextTriggerAt(workflowRequestVO, DateUtils.toNowMilli()));
        workflow.setFlowInfo("");
        workflow.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(workflowRequestVO.getGroupName() + workflowRequestVO.getWorkflowName())) % this.systemProperties.getBucketTotal()));
        workflow.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        Assert.isTrue((1 == this.workflowMapper.insert((Object)workflow) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u65b0\u589e\u5de5\u4f5c\u6d41\u5931\u8d25"));
        WorkflowRequestVO.NodeConfig nodeConfig = workflowRequestVO.getNodeConfig();
        this.workflowHandler.buildGraph(Lists.newArrayList((Object[])new Long[]{SystemConstants.ROOT}), new LinkedBlockingDeque<Long>(), workflowRequestVO.getGroupName(), workflow.getId(), nodeConfig, graph, workflow.getVersion());
        log.info("\u56fe\u6784\u5efa\u5b8c\u6210. graph:[{}]", graph);
        workflow.setVersion(null);
        workflow.setFlowInfo(JsonUtil.toJsonString((Object)GraphUtils.serializeGraphToJson(graph)));
        Assert.isTrue((1 == this.workflowMapper.updateById((Object)workflow) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u4fdd\u5b58\u5de5\u4f5c\u6d41\u56fe\u5931\u8d25"));
        return true;
    }

    private MutableGraph<Long> createGraph() {
        return GraphBuilder.directed().nodeOrder(ElementOrder.sorted((o1, o2) -> {
            if (o1 - o2 > 0L) {
                return 1;
            }
            if (o1 - o2 < 0L) {
                return -1;
            }
            return 0;
        })).incidentEdgeOrder(ElementOrder.stable()).allowsSelfLoops(false).build();
    }

    private static Long calculateNextTriggerAt(WorkflowRequestVO workflowRequestVO, Long time) {
        WorkflowServiceImpl.checkExecuteInterval(workflowRequestVO);
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)workflowRequestVO.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(workflowRequestVO.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    private static void checkExecuteInterval(WorkflowRequestVO requestVO) {
        if (Lists.newArrayList((Object[])new Integer[]{WaitStrategies.WaitStrategyEnum.FIXED.getType(), WaitStrategies.WaitStrategyEnum.RANDOM.getType()}).contains(requestVO.getTriggerType()) ? Integer.parseInt(requestVO.getTriggerInterval()) < 10 : requestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType() && CronUtils.getExecuteInterval((String)requestVO.getTriggerInterval()) < 10000L) {
            throw new EasyRetryServerException("\u89e6\u53d1\u95f4\u9694\u4e0d\u5f97\u5c0f\u4e8e10");
        }
    }

    @Override
    public WorkflowDetailResponseVO getWorkflowDetail(Long id) {
        Workflow workflow = (Workflow)this.workflowMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getId, (Object)id)).eq(Workflow::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId()));
        if (Objects.isNull(workflow)) {
            return null;
        }
        WorkflowDetailResponseVO responseVO = WorkflowConverter.INSTANCE.toWorkflowDetailResponseVO(workflow);
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)0)).eq(WorkflowNode::getVersion, (Object)workflow.getVersion())).eq(WorkflowNode::getWorkflowId, (Object)id)).orderByAsc(WorkflowNode::getPriorityLevel));
        List jobIds = workflowNodes.stream().map(WorkflowNode::getJobId).collect(Collectors.toList());
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, new HashSet(jobIds)));
        Map<Long, Job> jobMap = jobs.stream().collect(Collectors.toMap(Job::getId, job -> job));
        List<WorkflowDetailResponseVO.NodeInfo> nodeInfos = WorkflowConverter.INSTANCE.toNodeInfo(workflowNodes);
        Map<Long, WorkflowDetailResponseVO.NodeInfo> workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            JobTaskConfig jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponseVO.NodeInfo::getId, i -> i));
        String flowInfo = workflow.getFlowInfo();
        try {
            MutableGraph graph = GraphUtils.deserializeJsonToGraph((String)flowInfo);
            WorkflowDetailResponseVO.NodeConfig config = this.workflowHandler.buildNodeConfig((MutableGraph<Long>)graph, SystemConstants.ROOT, new HashMap<Long, WorkflowDetailResponseVO.NodeConfig>(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25. json:[{}]", (Object)flowInfo, (Object)e);
            throw new EasyRetryServerException("\u67e5\u8be2\u5de5\u4f5c\u6d41\u8be6\u60c5\u5931\u8d25");
        }
        return responseVO;
    }

    @Override
    public PageResult<List<WorkflowResponseVO>> listPage(WorkflowQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus());
        queryWrapper.eq(Workflow::getNamespaceId, (Object)userSessionVO.getNamespaceId());
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            queryWrapper.eq(Workflow::getGroupName, (Object)queryVO.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getWorkflowName())) {
            queryWrapper.like(Workflow::getWorkflowName, (Object)queryVO.getWorkflowName());
        }
        if (Objects.nonNull(queryVO.getWorkflowStatus())) {
            queryWrapper.eq(Workflow::getWorkflowStatus, (Object)queryVO.getWorkflowStatus());
        }
        queryWrapper.orderByDesc(Workflow::getId);
        PageDTO page = (PageDTO)this.workflowMapper.selectPage((IPage)pageDTO, (Wrapper)queryWrapper);
        List<WorkflowResponseVO> jobResponseList = WorkflowConverter.INSTANCE.toWorkflowResponseVO(page.getRecords());
        return new PageResult<List<WorkflowResponseVO>>(pageDTO, jobResponseList);
    }

    @Override
    @Transactional
    public Boolean updateWorkflow(WorkflowRequestVO workflowRequestVO) {
        Assert.notNull((Object)workflowRequestVO.getId(), () -> new EasyRetryServerException("\u5de5\u4f5c\u6d41ID\u4e0d\u80fd\u4e3a\u7a7a"));
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowRequestVO.getId());
        Assert.notNull((Object)workflow, () -> new EasyRetryServerException("\u5de5\u4f5c\u6d41\u4e0d\u5b58\u5728"));
        MutableGraph<Long> graph = this.createGraph();
        graph.addNode((Object)SystemConstants.ROOT);
        WorkflowRequestVO.NodeConfig nodeConfig = workflowRequestVO.getNodeConfig();
        int version = workflow.getVersion();
        this.workflowHandler.buildGraph(Lists.newArrayList((Object[])new Long[]{SystemConstants.ROOT}), new LinkedBlockingDeque<Long>(), workflowRequestVO.getGroupName(), workflowRequestVO.getId(), nodeConfig, graph, version + 1);
        log.info("\u56fe\u6784\u5efa\u5b8c\u6210. graph:[{}]", graph);
        workflow = WorkflowConverter.INSTANCE.toWorkflow(workflowRequestVO);
        workflow.setId(workflowRequestVO.getId());
        workflow.setVersion(Integer.valueOf(version));
        workflow.setNextTriggerAt(WorkflowServiceImpl.calculateNextTriggerAt(workflowRequestVO, DateUtils.toNowMilli()));
        workflow.setFlowInfo(JsonUtil.toJsonString((Object)GraphUtils.serializeGraphToJson(graph)));
        Assert.isTrue((this.workflowMapper.update((Object)workflow, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getId, (Object)workflow.getId())).eq(Workflow::getVersion, (Object)version)) > 0 ? 1 : 0) != 0, () -> new EasyRetryServerException("\u66f4\u65b0\u5931\u8d25"));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateStatus(Long id) {
        Workflow workflow = (Workflow)this.workflowMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Workflow::getId, Workflow::getWorkflowStatus}).eq(Workflow::getId, (Object)id));
        Assert.notNull((Object)workflow, () -> new EasyRetryServerException("\u5de5\u4f5c\u6d41\u4e0d\u5b58\u5728"));
        if (Objects.equals(workflow.getWorkflowStatus(), StatusEnum.NO.getStatus())) {
            workflow.setWorkflowStatus(StatusEnum.YES.getStatus());
        } else {
            workflow.setWorkflowStatus(StatusEnum.NO.getStatus());
        }
        return 1 == this.workflowMapper.updateById((Object)workflow);
    }

    @Override
    public Boolean deleteById(Long id) {
        Workflow workflow = new Workflow();
        workflow.setId(id);
        workflow.setDeleted(StatusEnum.YES.getStatus());
        return 1 == this.workflowMapper.updateById((Object)workflow);
    }

    @Override
    public Boolean trigger(Long id) {
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)id);
        Assert.notNull((Object)workflow, () -> new EasyRetryServerException("workflow can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)workflow.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)workflow.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new EasyRetryServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{workflow.getGroupName()}));
        WorkflowTaskPrepareDTO prepareDTO = WorkflowTaskConverter.INSTANCE.toWorkflowTaskPrepareDTO(workflow);
        prepareDTO.setNextTriggerAt(DateUtils.toNowMilli());
        prepareDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType());
        this.terminalWorkflowPrepareHandler.handler(prepareDTO);
        return Boolean.TRUE;
    }

    @Override
    public List<WorkflowResponseVO> getWorkflowNameList(String keywords, Long workflowId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper().select(new SFunction[]{Workflow::getId, Workflow::getWorkflowName});
        if (StrUtil.isNotBlank((CharSequence)keywords)) {
            queryWrapper.like(Workflow::getWorkflowName, (Object)(keywords.trim() + "%"));
        }
        if (Objects.nonNull(workflowId)) {
            queryWrapper.eq(Workflow::getId, (Object)workflowId);
        }
        queryWrapper.eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus());
        PageDTO pageDTO = new PageDTO(1L, 20L);
        PageDTO selectPage = (PageDTO)this.workflowMapper.selectPage((IPage)pageDTO, (Wrapper)queryWrapper);
        return WorkflowConverter.INSTANCE.toWorkflowResponseVO(selectPage.getRecords());
    }

    @Override
    public Pair<Integer, String> checkNodeExpression(DecisionConfig decisionConfig) {
        try {
            ExpressionEngine realExpressionEngine = ExpressionTypeEnum.valueOf((Integer)decisionConfig.getExpressionType());
            Assert.notNull((Object)realExpressionEngine, () -> new EasyRetryServerException("\u8868\u8fbe\u5f0f\u5f15\u64ce\u4e0d\u5b58\u5728"));
            ExpressionInvocationHandler invocationHandler = new ExpressionInvocationHandler((Object)realExpressionEngine);
            ExpressionEngine expressionEngine = ExpressionFactory.getExpressionEngine((InvocationHandler)invocationHandler);
            expressionEngine.eval(decisionConfig.getNodeExpression(), new Object[]{""});
        }
        catch (Exception e) {
            EasyRetryLog.LOCAL.error("\u8868\u8fbe\u5f0f\u5f02\u5e38. [{}]", new Object[]{decisionConfig.getNodeExpression(), e});
            return Pair.of((Object)StatusEnum.NO.getStatus(), (Object)e.getMessage());
        }
        return Pair.of((Object)StatusEnum.YES.getStatus(), (Object)"");
    }

    public WorkflowServiceImpl(WorkflowMapper workflowMapper, WorkflowNodeMapper workflowNodeMapper, SystemProperties systemProperties, WorkflowHandler workflowHandler, WorkflowPrePareHandler terminalWorkflowPrepareHandler, JobMapper jobMapper, AccessTemplate accessTemplate) {
        this.workflowMapper = workflowMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.systemProperties = systemProperties;
        this.workflowHandler = workflowHandler;
        this.terminalWorkflowPrepareHandler = terminalWorkflowPrepareHandler;
        this.jobMapper = jobMapper;
        this.accessTemplate = accessTemplate;
    }
}

