/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.constant.SystemConstants;
import com.aizuda.easy.retry.common.core.enums.JobOperationReasonEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.server.common.dto.JobTaskConfig;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.job.task.support.cache.MutableGraphCache;
import com.aizuda.easy.retry.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.request.WorkflowBatchQueryVO;
import com.aizuda.easy.retry.server.web.model.response.JobBatchResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowBatchResponseVO;
import com.aizuda.easy.retry.server.web.model.response.WorkflowDetailResponseVO;
import com.aizuda.easy.retry.server.web.service.WorkflowBatchService;
import com.aizuda.easy.retry.server.web.service.convert.JobBatchResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.convert.WorkflowConverter;
import com.aizuda.easy.retry.server.web.service.handler.WorkflowHandler;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.persistence.dataobject.WorkflowBatchQueryDO;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTaskBatch;
import com.aizuda.easy.retry.template.datasource.persistence.po.Workflow;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowNode;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WorkflowBatchServiceImpl
implements WorkflowBatchService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowBatchServiceImpl.class);
    private static final Integer NOT_HANDLE_STATUS = 99;
    private static final Integer WORKFLOW_DECISION_FAILED_STATUS = 98;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;
    private final WorkflowMapper workflowMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final WorkflowHandler workflowHandler;
    private final WorkflowBatchHandler workflowBatchHandler;
    private final JobMapper jobMapper;

    @Override
    public PageResult<List<WorkflowBatchResponseVO>> listPage(WorkflowBatchQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<Object> groupNames = Lists.newArrayList();
        if (userSessionVO.isUser()) {
            groupNames = userSessionVO.getGroupNames();
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            if (!CollectionUtils.isEmpty((Collection)groupNames) && !groupNames.contains(queryVO.getGroupName())) {
                return new PageResult<List<WorkflowBatchResponseVO>>(pageDTO, Lists.newArrayList());
            }
            groupNames = Lists.newArrayList((Object[])new String[]{queryVO.getGroupName()});
        }
        WorkflowBatchQueryDO workflowBatchQueryDO = new WorkflowBatchQueryDO();
        if (StrUtil.isNotBlank((CharSequence)queryVO.getWorkflowName())) {
            workflowBatchQueryDO.setWorkflowName(queryVO.getWorkflowName() + "%");
        }
        workflowBatchQueryDO.setWorkflowId(queryVO.getWorkflowId());
        workflowBatchQueryDO.setTaskBatchStatus(queryVO.getTaskBatchStatus());
        workflowBatchQueryDO.setGroupNames(groupNames);
        workflowBatchQueryDO.setNamespaceId(userSessionVO.getNamespaceId());
        List batchResponseDOList = this.workflowTaskBatchMapper.selectWorkflowBatchPageList(pageDTO, workflowBatchQueryDO);
        List<WorkflowBatchResponseVO> batchResponseVOList = WorkflowConverter.INSTANCE.toWorkflowBatchResponseVO(batchResponseDOList);
        return new PageResult<List<WorkflowBatchResponseVO>>(pageDTO, batchResponseVOList);
    }

    @Override
    public WorkflowDetailResponseVO getWorkflowBatchDetail(Long id) {
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getId, (Object)id)).eq(WorkflowTaskBatch::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId()));
        if (Objects.isNull(workflowTaskBatch)) {
            return null;
        }
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowTaskBatch.getWorkflowId());
        WorkflowDetailResponseVO responseVO = WorkflowConverter.INSTANCE.toWorkflowDetailResponseVO(workflow);
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(WorkflowNode::getWorkflowId, (Object)workflow.getId()));
        List jobIds = workflowNodes.stream().map(WorkflowNode::getJobId).collect(Collectors.toList());
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, new HashSet(jobIds)));
        Map<Long, Job> jobMap = jobs.stream().collect(Collectors.toMap(Job::getId, job -> job));
        List alJobTaskBatchList = this.jobTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(JobTaskBatch::getWorkflowTaskBatchId, (Object)id)).orderByDesc(JobTaskBatch::getId));
        Map<Long, List<JobTaskBatch>> jobTaskBatchMap = alJobTaskBatchList.stream().collect(Collectors.groupingBy(JobTaskBatch::getWorkflowNodeId));
        List<WorkflowDetailResponseVO.NodeInfo> nodeInfos = WorkflowConverter.INSTANCE.toNodeInfo(workflowNodes);
        String flowInfo = workflowTaskBatch.getFlowInfo();
        MutableGraph graph = MutableGraphCache.getOrDefault((Long)id, (String)flowInfo);
        HashSet allNoOperationNode = Sets.newHashSet();
        Map<Long, WorkflowDetailResponseVO.NodeInfo> workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            List<JobTaskBatch> jobTaskBatchList;
            JobTaskConfig jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
            }
            if (!CollectionUtils.isEmpty((Collection)(jobTaskBatchList = (List<JobTaskBatch>)jobTaskBatchMap.get(nodeInfo.getId())))) {
                jobTaskBatchList = jobTaskBatchList.stream().sorted(Comparator.comparingInt(JobTaskBatch::getTaskBatchStatus)).collect(Collectors.toList());
                nodeInfo.setJobBatchList(JobBatchResponseVOConverter.INSTANCE.jobTaskBatchToJobBatchResponseVOs(jobTaskBatchList));
                JobTaskBatch jobTaskBatch = jobTaskBatchList.get(0);
                if (JobOperationReasonEnum.WORKFLOW_DECISION_FAILED.getReason() == jobTaskBatch.getOperationReason().intValue()) {
                    nodeInfo.setTaskBatchStatus(WORKFLOW_DECISION_FAILED_STATUS);
                } else {
                    nodeInfo.setTaskBatchStatus(jobTaskBatch.getTaskBatchStatus());
                }
                if (jobTaskBatchList.stream().filter(Objects::nonNull).anyMatch(WorkflowBatchServiceImpl::isNoOperation)) {
                    Set allDescendants = MutableGraphCache.getAllDescendants((MutableGraph)graph, (Long)nodeInfo.getId());
                    allNoOperationNode.addAll(allDescendants);
                } else {
                    allNoOperationNode.remove(nodeInfo.getId());
                }
            } else if (JobTaskBatchStatusEnum.NOT_SUCCESS.contains(workflowTaskBatch.getTaskBatchStatus())) {
                allNoOperationNode.add(nodeInfo.getId());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponseVO.NodeInfo::getId, i -> i));
        for (Long noOperationNodeId : allNoOperationNode) {
            WorkflowDetailResponseVO.NodeInfo nodeInfo2 = workflowNodeMap.get(noOperationNodeId);
            JobBatchResponseVO jobBatchResponseVO = new JobBatchResponseVO();
            JobTaskConfig jobTask = nodeInfo2.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobBatchResponseVO.setJobId(jobTask.getJobId());
            }
            nodeInfo2.setTaskBatchStatus(NOT_HANDLE_STATUS);
            jobBatchResponseVO.setTaskBatchStatus(NOT_HANDLE_STATUS);
            jobBatchResponseVO.setOperationReason(JobOperationReasonEnum.WORKFLOW_NODE_NO_REQUIRED.getReason());
            nodeInfo2.setJobBatchList(Lists.newArrayList((Object[])new JobBatchResponseVO[]{jobBatchResponseVO}));
        }
        try {
            WorkflowDetailResponseVO.NodeConfig config = this.workflowHandler.buildNodeConfig((MutableGraph<Long>)graph, SystemConstants.ROOT, new HashMap<Long, WorkflowDetailResponseVO.NodeConfig>(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25. json:[{}]", (Object)flowInfo, (Object)e);
            throw new EasyRetryServerException("\u67e5\u8be2\u5de5\u4f5c\u6d41\u6279\u6b21\u8be6\u60c5\u5931\u8d25");
        }
        return responseVO;
    }

    @Override
    public Boolean stop(Long id) {
        WorkflowTaskBatch workflowTaskBatch = (WorkflowTaskBatch)this.workflowTaskBatchMapper.selectById((Serializable)id);
        Assert.notNull((Object)workflowTaskBatch, () -> new EasyRetryServerException("workflow batch can not be null."));
        this.workflowBatchHandler.stop(id, Integer.valueOf(JobOperationReasonEnum.MANNER_STOP.getReason()));
        return Boolean.TRUE;
    }

    private static boolean isNoOperation(JobTaskBatch i) {
        return JobOperationReasonEnum.WORKFLOW_SUCCESSOR_SKIP_EXECUTION.contains(i.getOperationReason()) || i.getTaskBatchStatus().intValue() == JobTaskBatchStatusEnum.STOP.getStatus();
    }

    public WorkflowBatchServiceImpl(WorkflowTaskBatchMapper workflowTaskBatchMapper, WorkflowMapper workflowMapper, WorkflowNodeMapper workflowNodeMapper, JobTaskBatchMapper jobTaskBatchMapper, WorkflowHandler workflowHandler, WorkflowBatchHandler workflowBatchHandler, JobMapper jobMapper) {
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
        this.workflowMapper = workflowMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.workflowHandler = workflowHandler;
        this.workflowBatchHandler = workflowBatchHandler;
        this.jobMapper = jobMapper;
    }
}

