/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.client.model.GenerateRetryIdempotentIdDTO;
import com.aizuda.easy.retry.common.core.enums.RetryStatusEnum;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.common.core.model.Result;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.WaitStrategy;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.client.RequestBuilder;
import com.aizuda.easy.retry.server.common.dto.RegisterNodeInfo;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.easy.retry.server.common.enums.TaskGeneratorSceneEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.easy.retry.server.common.strategy.WaitStrategies;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.model.dto.RetryTaskDTO;
import com.aizuda.easy.retry.server.retry.task.client.RetryRpcClient;
import com.aizuda.easy.retry.server.retry.task.generator.task.TaskContext;
import com.aizuda.easy.retry.server.retry.task.generator.task.TaskGenerator;
import com.aizuda.easy.retry.server.retry.task.support.dispatch.task.TaskExecutor;
import com.aizuda.easy.retry.server.retry.task.support.dispatch.task.TaskExecutorSceneEnum;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.BatchDeleteRetryTaskVO;
import com.aizuda.easy.retry.server.web.model.request.GenerateRetryIdempotentIdVO;
import com.aizuda.easy.retry.server.web.model.request.ManualTriggerTaskRequestVO;
import com.aizuda.easy.retry.server.web.model.request.ParseLogsVO;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskQueryVO;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskSaveRequestVO;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskUpdateExecutorNameRequestVO;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskUpdateStatusRequestVO;
import com.aizuda.easy.retry.server.web.model.response.RetryTaskResponseVO;
import com.aizuda.easy.retry.server.web.service.RetryTaskService;
import com.aizuda.easy.retry.server.web.service.convert.RetryTaskResponseVOConverter;
import com.aizuda.easy.retry.server.web.service.convert.TaskContextConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.access.TaskAccess;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTask;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLogMessage;
import com.aizuda.easy.retry.template.datasource.persistence.po.SceneConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RetryTaskServiceImpl
implements RetryTaskService {
    @Autowired
    private ClientNodeAllocateHandler clientNodeAllocateHandler;
    @Autowired
    private RetryTaskLogMessageMapper retryTaskLogMessageMapper;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    @Lazy
    private List<TaskGenerator> taskGenerators;
    @Lazy
    @Autowired
    private List<TaskExecutor> taskExecutors;

    @Override
    public PageResult<List<RetryTaskResponseVO>> getRetryTaskPage(RetryTaskQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        LambdaQueryWrapper retryTaskLambdaQueryWrapper = new LambdaQueryWrapper();
        retryTaskLambdaQueryWrapper.eq(RetryTask::getNamespaceId, (Object)namespaceId);
        if (!StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            return new PageResult<List<RetryTaskResponseVO>>(pageDTO, new ArrayList());
        }
        retryTaskLambdaQueryWrapper.eq(RetryTask::getGroupName, (Object)queryVO.getGroupName());
        if (StrUtil.isNotBlank((CharSequence)queryVO.getSceneName())) {
            retryTaskLambdaQueryWrapper.eq(RetryTask::getSceneName, (Object)queryVO.getSceneName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getBizNo())) {
            retryTaskLambdaQueryWrapper.eq(RetryTask::getBizNo, (Object)queryVO.getBizNo());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId())) {
            retryTaskLambdaQueryWrapper.eq(RetryTask::getIdempotentId, (Object)queryVO.getIdempotentId());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId())) {
            retryTaskLambdaQueryWrapper.eq(RetryTask::getUniqueId, (Object)queryVO.getUniqueId());
        }
        if (Objects.nonNull(queryVO.getRetryStatus())) {
            retryTaskLambdaQueryWrapper.eq(RetryTask::getRetryStatus, (Object)queryVO.getRetryStatus());
        }
        retryTaskLambdaQueryWrapper.select(new SFunction[]{RetryTask::getId, RetryTask::getBizNo, RetryTask::getIdempotentId, RetryTask::getGroupName, RetryTask::getNextTriggerAt, RetryTask::getRetryCount, RetryTask::getRetryStatus, RetryTask::getUpdateDt, RetryTask::getSceneName, RetryTask::getUniqueId, RetryTask::getTaskType});
        pageDTO = this.accessTemplate.getRetryTaskAccess().listPage(queryVO.getGroupName(), namespaceId, pageDTO, (LambdaQueryWrapper)retryTaskLambdaQueryWrapper.orderByDesc(RetryTask::getCreateDt));
        return new PageResult<List<RetryTaskResponseVO>>(pageDTO, RetryTaskResponseVOConverter.INSTANCE.toRetryTaskResponseVO(pageDTO.getRecords()));
    }

    @Override
    public RetryTaskResponseVO getRetryTaskById(String groupName, Long id) {
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(groupName, UserSessionUtils.currentUserSession().getNamespaceId(), (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getId, (Object)id));
        return RetryTaskResponseVOConverter.INSTANCE.toRetryTaskResponseVO(retryTask);
    }

    @Override
    @Transactional
    public int updateRetryTaskStatus(RetryTaskUpdateStatusRequestVO requestVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)requestVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new EasyRetryServerException("\u91cd\u8bd5\u72b6\u6001\u9519\u8bef. [{}]", new Object[]{requestVO.getRetryStatus()});
        }
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        RetryTask retryTask = (RetryTask)retryTaskAccess.one(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getId, (Object)requestVO.getId()));
        if (Objects.isNull(retryTask)) {
            throw new EasyRetryServerException("\u672a\u67e5\u8be2\u5230\u91cd\u8bd5\u4efb\u52a1");
        }
        retryTask.setRetryStatus(requestVO.getRetryStatus());
        retryTask.setGroupName(requestVO.getGroupName());
        if (RetryStatusEnum.RUNNING.getStatus().equals(retryStatusEnum.getStatus())) {
            SceneConfig sceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(retryTask.getGroupName(), retryTask.getSceneName(), namespaceId);
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(DateUtils.toNowMilli());
            waitStrategyContext.setTriggerInterval(sceneConfig.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(retryTask.getRetryCount() + 1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)sceneConfig.getBackOff());
            retryTask.setNextTriggerAt(DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext)));
        }
        if (RetryStatusEnum.FINISH.getStatus().equals(retryStatusEnum.getStatus())) {
            RetryTaskLogMessage retryTaskLogMessage = new RetryTaskLogMessage();
            retryTaskLogMessage.setUniqueId(retryTask.getUniqueId());
            retryTaskLogMessage.setGroupName(retryTask.getGroupName());
            retryTaskLogMessage.setMessage("\u624b\u52a8\u64cd\u4f5c\u5b8c\u6210");
            retryTaskLogMessage.setCreateDt(LocalDateTime.now());
            this.retryTaskLogMessageMapper.insert((Object)retryTaskLogMessage);
        }
        RetryTaskLog retryTaskLog = new RetryTaskLog();
        retryTaskLog.setRetryStatus(requestVO.getRetryStatus());
        this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).eq(RetryTaskLog::getUniqueId, (Object)retryTask.getUniqueId())).eq(RetryTaskLog::getGroupName, (Object)retryTask.getGroupName()));
        retryTask.setUpdateDt(LocalDateTime.now());
        return retryTaskAccess.updateById(requestVO.getGroupName(), namespaceId, (Object)retryTask);
    }

    @Override
    public int saveRetryTask(RetryTaskSaveRequestVO retryTaskRequestVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)retryTaskRequestVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new EasyRetryServerException("\u91cd\u8bd5\u72b6\u6001\u9519\u8bef");
        }
        TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.MANA_SINGLE.getScene())).findFirst().orElseThrow(() -> new EasyRetryServerException("\u6ca1\u6709\u5339\u914d\u7684\u4efb\u52a1\u751f\u6210\u5668"));
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskContext taskContext = new TaskContext();
        taskContext.setSceneName(retryTaskRequestVO.getSceneName());
        taskContext.setGroupName(retryTaskRequestVO.getGroupName());
        taskContext.setInitStatus(retryTaskRequestVO.getRetryStatus());
        taskContext.setNamespaceId(namespaceId);
        taskContext.setTaskInfos(Collections.singletonList(TaskContextConverter.INSTANCE.toTaskContextInfo(retryTaskRequestVO)));
        taskGenerator.taskGenerator(taskContext);
        return 1;
    }

    @Override
    public String idempotentIdGenerate(GenerateRetryIdempotentIdVO generateRetryIdempotentIdVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Set serverNodes = CacheRegisterTable.getServerNodeSet((String)generateRetryIdempotentIdVO.getGroupName(), (String)namespaceId);
        Assert.notEmpty((Iterable)serverNodes, () -> new EasyRetryServerException("\u751f\u6210idempotentId\u5931\u8d25: \u4e0d\u5b58\u5728\u6d3b\u8dc3\u7684\u5ba2\u6237\u7aef\u8282\u70b9"));
        SceneConfig sceneConfig = this.accessTemplate.getSceneConfigAccess().getSceneConfigByGroupNameAndSceneName(generateRetryIdempotentIdVO.getGroupName(), generateRetryIdempotentIdVO.getSceneName(), namespaceId);
        RegisterNodeInfo serverNode = this.clientNodeAllocateHandler.getServerNode(sceneConfig.getSceneName(), sceneConfig.getGroupName(), sceneConfig.getNamespaceId(), sceneConfig.getRouteKey());
        GenerateRetryIdempotentIdDTO generateRetryIdempotentIdDTO = new GenerateRetryIdempotentIdDTO();
        generateRetryIdempotentIdDTO.setGroup(generateRetryIdempotentIdVO.getGroupName());
        generateRetryIdempotentIdDTO.setScene(generateRetryIdempotentIdVO.getSceneName());
        generateRetryIdempotentIdDTO.setArgsStr(generateRetryIdempotentIdVO.getArgsStr());
        generateRetryIdempotentIdDTO.setExecutorName(generateRetryIdempotentIdVO.getExecutorName());
        RetryRpcClient rpcClient = (RetryRpcClient)RequestBuilder.newBuilder().nodeInfo(serverNode).namespaceId(serverNode.getNamespaceId()).client(RetryRpcClient.class).build();
        Result result = rpcClient.generateIdempotentId(generateRetryIdempotentIdDTO);
        Assert.notNull((Object)result, () -> new EasyRetryServerException("idempotentId\u751f\u6210\u5931\u8d25"));
        Assert.isTrue((1 == result.getStatus() ? 1 : 0) != 0, () -> new EasyRetryServerException("idempotentId\u751f\u6210\u5931\u8d25:\u8bf7\u786e\u4fdd\u53c2\u6570\u4e0e\u6267\u884c\u5668\u540d\u79f0\u6b63\u786e"));
        return (String)result.getData();
    }

    @Override
    public int updateRetryTaskExecutorName(RetryTaskUpdateExecutorNameRequestVO requestVO) {
        RetryTask retryTask = new RetryTask();
        retryTask.setExecutorName(requestVO.getExecutorName());
        retryTask.setRetryStatus(requestVO.getRetryStatus());
        retryTask.setUpdateDt(LocalDateTime.now());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        return retryTaskAccess.update(requestVO.getGroupName(), namespaceId, (Object)retryTask, (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)requestVO.getGroupName())).in(RetryTask::getId, requestVO.getIds()));
    }

    @Override
    public Integer deleteRetryTask(BatchDeleteRetryTaskVO requestVO) {
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        return retryTaskAccess.delete(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getGroupName, (Object)requestVO.getGroupName())).in(RetryTask::getId, requestVO.getIds()));
    }

    @Override
    public Integer parseLogs(ParseLogsVO parseLogsVO) {
        RetryStatusEnum retryStatusEnum = RetryStatusEnum.getByStatus((Integer)parseLogsVO.getRetryStatus());
        if (Objects.isNull(retryStatusEnum)) {
            throw new EasyRetryServerException("\u91cd\u8bd5\u72b6\u6001\u9519\u8bef");
        }
        String logStr = parseLogsVO.getLogStr();
        String patternString = "<\\|>(.*?)<\\|>";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(logStr);
        ArrayList waitInsertList = new ArrayList();
        while (matcher.find()) {
            List retryTaskList;
            String extractedData = matcher.group(1);
            if (StrUtil.isBlank((CharSequence)extractedData) || CollectionUtils.isEmpty((Collection)(retryTaskList = JsonUtil.parseList((String)extractedData, RetryTaskDTO.class)))) continue;
            waitInsertList.addAll(retryTaskList);
        }
        Assert.isFalse((boolean)waitInsertList.isEmpty(), () -> new EasyRetryServerException("\u672a\u627e\u5230\u5339\u914d\u7684\u6570\u636e"));
        Assert.isTrue((waitInsertList.size() <= 500 ? 1 : 0) != 0, () -> new EasyRetryServerException("\u6700\u591a\u53ea\u80fd\u5904\u7406500\u6761\u6570\u636e"));
        TaskGenerator taskGenerator = this.taskGenerators.stream().filter(t -> t.supports(TaskGeneratorSceneEnum.MANA_BATCH.getScene())).findFirst().orElseThrow(() -> new EasyRetryServerException("\u6ca1\u6709\u5339\u914d\u7684\u4efb\u52a1\u751f\u6210\u5668"));
        boolean allMatch = waitInsertList.stream().allMatch(retryTaskDTO -> retryTaskDTO.getGroupName().equals(parseLogsVO.getGroupName()));
        Assert.isTrue((boolean)allMatch, () -> new EasyRetryServerException("\u5b58\u5728\u6570\u636egroupName\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u60a8\u7684\u6570\u636e"));
        Map<String, List<RetryTaskDTO>> map = waitInsertList.stream().collect(Collectors.groupingBy(RetryTaskDTO::getSceneName));
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        map.forEach((sceneName, retryTaskDTOS) -> {
            TaskContext taskContext = new TaskContext();
            taskContext.setSceneName(sceneName);
            taskContext.setGroupName(parseLogsVO.getGroupName());
            taskContext.setNamespaceId(namespaceId);
            taskContext.setInitStatus(parseLogsVO.getRetryStatus());
            taskContext.setTaskInfos(TaskContextConverter.INSTANCE.toTaskContextInfo((List<RetryTaskDTO>)retryTaskDTOS));
            taskGenerator.taskGenerator(taskContext);
        });
        return waitInsertList.size();
    }

    @Override
    public boolean manualTriggerRetryTask(ManualTriggerTaskRequestVO requestVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)requestVO.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new EasyRetryServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{requestVO.getGroupName()}));
        List<String> uniqueIds = requestVO.getUniqueIds();
        List list = this.accessTemplate.getRetryTaskAccess().list(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.RETRY.getType())).in(RetryTask::getUniqueId, uniqueIds));
        Assert.notEmpty((Iterable)list, () -> new EasyRetryServerException("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u4efb\u52a1"));
        for (RetryTask retryTask : list) {
            for (TaskExecutor taskExecutor : this.taskExecutors) {
                if (taskExecutor.getTaskType().getScene() != TaskExecutorSceneEnum.MANUAL_RETRY.getScene()) continue;
                taskExecutor.actuator(retryTask);
            }
        }
        return true;
    }

    @Override
    public boolean manualTriggerCallbackTask(ManualTriggerTaskRequestVO requestVO) {
        List<String> uniqueIds = requestVO.getUniqueIds();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)requestVO.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)namespaceId)).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new EasyRetryServerException("\u7ec4:[{}]\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u652f\u6301\u624b\u52a8\u6267\u884c.", new Object[]{requestVO.getGroupName()}));
        List list = this.accessTemplate.getRetryTaskAccess().list(requestVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryTask::getNamespaceId, (Object)namespaceId)).eq(RetryTask::getTaskType, (Object)SyetemTaskTypeEnum.CALLBACK.getType())).in(RetryTask::getUniqueId, uniqueIds));
        Assert.notEmpty((Iterable)list, () -> new EasyRetryServerException("\u6ca1\u6709\u53ef\u6267\u884c\u7684\u4efb\u52a1"));
        for (RetryTask retryTask : list) {
            for (TaskExecutor taskExecutor : this.taskExecutors) {
                if (taskExecutor.getTaskType().getScene() != TaskExecutorSceneEnum.MANUAL_CALLBACK.getScene()) continue;
                taskExecutor.actuator(retryTask);
            }
        }
        return true;
    }
}

