/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskLogMessageQueryVO;
import com.aizuda.easy.retry.server.web.model.request.RetryTaskLogQueryVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.RetryTaskLogMessageResponseVO;
import com.aizuda.easy.retry.server.web.model.response.RetryTaskLogResponseVO;
import com.aizuda.easy.retry.server.web.service.RetryTaskLogService;
import com.aizuda.easy.retry.server.web.service.convert.RetryTaskLogResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMessageMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLogMessage;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetryTaskLogServiceImpl
implements RetryTaskLogService {
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;
    @Autowired
    private RetryTaskLogMessageMapper retryTaskLogMessageMapper;

    @Override
    public PageResult<List<RetryTaskLogResponseVO>> getRetryTaskLogPage(RetryTaskLogQueryVO queryVO) {
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        String namespaceId = userSessionVO.getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper retryTaskLogLambdaQueryWrapper = new LambdaQueryWrapper();
        retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getNamespaceId, (Object)namespaceId);
        if (userSessionVO.isUser()) {
            retryTaskLogLambdaQueryWrapper.in(RetryTaskLog::getGroupName, userSessionVO.getGroupNames());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getGroupName, (Object)queryVO.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getSceneName())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getSceneName, (Object)queryVO.getSceneName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getBizNo())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getBizNo, (Object)queryVO.getBizNo());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getUniqueId, (Object)queryVO.getUniqueId());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLog::getIdempotentId, (Object)queryVO.getIdempotentId());
        }
        retryTaskLogLambdaQueryWrapper.select(new SFunction[]{RetryTaskLog::getGroupName, RetryTaskLog::getId, RetryTaskLog::getSceneName, RetryTaskLog::getIdempotentId, RetryTaskLog::getBizNo, RetryTaskLog::getRetryStatus, RetryTaskLog::getCreateDt, RetryTaskLog::getUniqueId, RetryTaskLog::getTaskType});
        PageDTO retryTaskLogPageDTO = (PageDTO)this.retryTaskLogMapper.selectPage((IPage)pageDTO, (Wrapper)retryTaskLogLambdaQueryWrapper.orderByDesc(RetryTaskLog::getCreateDt));
        return new PageResult<List<RetryTaskLogResponseVO>>(retryTaskLogPageDTO, RetryTaskLogResponseVOConverter.INSTANCE.batchConvert(retryTaskLogPageDTO.getRecords()));
    }

    @Override
    public PageResult<List<RetryTaskLogMessageResponseVO>> getRetryTaskLogMessagePage(RetryTaskLogMessageQueryVO queryVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        LambdaQueryWrapper retryTaskLogLambdaQueryWrapper = new LambdaQueryWrapper();
        retryTaskLogLambdaQueryWrapper.eq(RetryTaskLogMessage::getNamespaceId, (Object)namespaceId);
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLogMessage::getGroupName, (Object)queryVO.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId())) {
            retryTaskLogLambdaQueryWrapper.eq(RetryTaskLogMessage::getUniqueId, (Object)queryVO.getUniqueId());
        }
        PageDTO retryTaskLogPageDTO = (PageDTO)this.retryTaskLogMessageMapper.selectPage((IPage)pageDTO, (Wrapper)retryTaskLogLambdaQueryWrapper.orderByDesc(RetryTaskLogMessage::getCreateDt));
        return new PageResult<List<RetryTaskLogMessageResponseVO>>(retryTaskLogPageDTO, RetryTaskLogResponseVOConverter.INSTANCE.toRetryTaskLogMessageResponseVO(retryTaskLogPageDTO.getRecords()));
    }

    @Override
    public RetryTaskLogResponseVO getRetryTaskLogById(Long id) {
        RetryTaskLog retryTaskLog = (RetryTaskLog)this.retryTaskLogMapper.selectById((Serializable)id);
        return RetryTaskLogResponseVOConverter.INSTANCE.convert(retryTaskLog);
    }
}

