/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.enums.RetryStatusEnum;
import com.aizuda.easy.retry.server.common.WaitStrategy;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.strategy.WaitStrategies;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.retry.task.support.RetryTaskConverter;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.BatchDeleteRetryDeadLetterVO;
import com.aizuda.easy.retry.server.web.model.request.BatchRollBackRetryDeadLetterVO;
import com.aizuda.easy.retry.server.web.model.request.RetryDeadLetterQueryVO;
import com.aizuda.easy.retry.server.web.model.response.RetryDeadLetterResponseVO;
import com.aizuda.easy.retry.server.web.service.RetryDeadLetterService;
import com.aizuda.easy.retry.server.web.service.convert.RetryDeadLetterResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.access.ConfigAccess;
import com.aizuda.easy.retry.template.datasource.access.TaskAccess;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.RetryTaskLogMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTask;
import com.aizuda.easy.retry.template.datasource.persistence.po.RetryTaskLog;
import com.aizuda.easy.retry.template.datasource.persistence.po.SceneConfig;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RetryDeadLetterServiceImpl
implements RetryDeadLetterService {
    @Autowired
    private AccessTemplate accessTemplate;
    @Autowired
    private RetryTaskLogMapper retryTaskLogMapper;

    @Override
    public PageResult<List<RetryDeadLetterResponseVO>> getRetryDeadLetterPage(RetryDeadLetterQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        if (StrUtil.isBlank((CharSequence)queryVO.getGroupName())) {
            return new PageResult<List<RetryDeadLetterResponseVO>>(pageDTO, new ArrayList());
        }
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(RetryDeadLetter::getNamespaceId, (Object)namespaceId);
        queryWrapper.eq(RetryDeadLetter::getGroupName, (Object)queryVO.getGroupName());
        if (StrUtil.isNotBlank((CharSequence)queryVO.getSceneName())) {
            queryWrapper.eq(RetryDeadLetter::getSceneName, (Object)queryVO.getSceneName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getBizNo())) {
            queryWrapper.eq(RetryDeadLetter::getBizNo, (Object)queryVO.getBizNo());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getIdempotentId())) {
            queryWrapper.eq(RetryDeadLetter::getIdempotentId, (Object)queryVO.getIdempotentId());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getUniqueId())) {
            queryWrapper.eq(RetryDeadLetter::getUniqueId, (Object)queryVO.getUniqueId());
        }
        PageDTO retryDeadLetterPageDTO = this.accessTemplate.getRetryDeadLetterAccess().listPage(queryVO.getGroupName(), namespaceId, pageDTO, queryWrapper);
        return new PageResult<List<RetryDeadLetterResponseVO>>(retryDeadLetterPageDTO, RetryDeadLetterResponseVOConverter.INSTANCE.batchConvert(retryDeadLetterPageDTO.getRecords()));
    }

    @Override
    public RetryDeadLetterResponseVO getRetryDeadLetterById(String groupName, Long id) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        RetryDeadLetter retryDeadLetter = (RetryDeadLetter)retryDeadLetterAccess.one(groupName, namespaceId, (LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getId, (Object)id));
        return RetryDeadLetterResponseVOConverter.INSTANCE.convert(retryDeadLetter);
    }

    @Override
    @Transactional
    public int rollback(BatchRollBackRetryDeadLetterVO rollBackRetryDeadLetterVO) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        String groupName = rollBackRetryDeadLetterVO.getGroupName();
        List<Long> ids = rollBackRetryDeadLetterVO.getIds();
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        List retryDeadLetterList = retryDeadLetterAccess.list(groupName, namespaceId, (LambdaQueryWrapper)new LambdaQueryWrapper().in(RetryDeadLetter::getId, ids));
        Assert.notEmpty((Iterable)retryDeadLetterList, () -> new EasyRetryServerException("\u6570\u636e\u4e0d\u5b58\u5728"));
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        Set sceneNameSet = retryDeadLetterList.stream().map(RetryDeadLetter::getSceneName).collect(Collectors.toSet());
        List sceneConfigs = sceneConfigAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SceneConfig::getNamespaceId, (Object)namespaceId)).in(SceneConfig::getSceneName, sceneNameSet));
        Map sceneConfigMap = sceneConfigs.stream().collect(Collectors.toMap(sceneConfig -> sceneConfig.getGroupName() + sceneConfig.getSceneName(), Function.identity()));
        ArrayList<RetryTask> waitRollbackList = new ArrayList<RetryTask>();
        for (RetryDeadLetter retryDeadLetter : retryDeadLetterList) {
            SceneConfig sceneConfig2 = (SceneConfig)sceneConfigMap.get(retryDeadLetter.getGroupName() + retryDeadLetter.getSceneName());
            Assert.notNull((Object)sceneConfig2, () -> new EasyRetryServerException("\u672a\u67e5\u8be2\u5230\u573a\u666f. [{}]", new Object[]{retryDeadLetter.getSceneName()}));
            RetryTask retryTask = RetryTaskConverter.INSTANCE.toRetryTask(retryDeadLetter);
            retryTask.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
            retryTask.setTaskType(SyetemTaskTypeEnum.RETRY.getType());
            WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
            waitStrategyContext.setNextTriggerAt(LocalDateTime.now());
            waitStrategyContext.setTriggerInterval(sceneConfig2.getTriggerInterval());
            waitStrategyContext.setDelayLevel(Integer.valueOf(1));
            WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)sceneConfig2.getBackOff());
            retryTask.setNextTriggerAt(DateUtils.toLocalDateTime((long)waitStrategy.computeTriggerTime(waitStrategyContext)));
            retryTask.setCreateDt(LocalDateTime.now());
            waitRollbackList.add(retryTask);
        }
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryTaskAccess();
        Assert.isTrue((waitRollbackList.size() == retryTaskAccess.batchInsert(groupName, namespaceId, waitRollbackList) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u65b0\u589e\u91cd\u8bd5\u4efb\u52a1\u5931\u8d25"));
        Set waitDelRetryDeadLetterIdSet = retryDeadLetterList.stream().map(RetryDeadLetter::getId).collect(Collectors.toSet());
        Assert.isTrue((waitDelRetryDeadLetterIdSet.size() == retryDeadLetterAccess.delete(groupName, namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getGroupName, (Object)groupName)).in(RetryDeadLetter::getId, waitDelRetryDeadLetterIdSet)) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u5220\u9664\u6b7b\u4fe1\u961f\u5217\u6570\u636e\u5931\u8d25"));
        RetryTaskLog retryTaskLog = new RetryTaskLog();
        retryTaskLog.setRetryStatus(RetryStatusEnum.RUNNING.getStatus());
        Set uniqueIdSet = waitRollbackList.stream().map(RetryTask::getUniqueId).collect(Collectors.toSet());
        int update = this.retryTaskLogMapper.update((Object)retryTaskLog, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetryTaskLog::getNamespaceId, (Object)namespaceId)).in(RetryTaskLog::getUniqueId, uniqueIdSet)).eq(RetryTaskLog::getGroupName, (Object)groupName));
        Assert.isTrue((update == uniqueIdSet.size() ? 1 : 0) != 0, () -> new EasyRetryServerException("\u56de\u6eda\u65e5\u5fd7\u72b6\u6001\u5931\u8d25, \u53ef\u80fd\u539f\u56e0: \u65e5\u5fd7\u4fe1\u606f\u7f3a\u5931\u6216\u5b58\u5728\u591a\u4e2a\u76f8\u540cuniqueId"));
        return update;
    }

    @Override
    public int batchDelete(BatchDeleteRetryDeadLetterVO deadLetterVO) {
        TaskAccess retryDeadLetterAccess = this.accessTemplate.getRetryDeadLetterAccess();
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        return retryDeadLetterAccess.delete(deadLetterVO.getGroupName(), namespaceId, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getNamespaceId, (Object)namespaceId)).eq(RetryDeadLetter::getGroupName, (Object)deadLetterVO.getGroupName())).in(RetryDeadLetter::getId, deadLetterVO.getIds()));
    }
}

