/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.NotifyConfigQueryVO;
import com.aizuda.easy.retry.server.web.model.request.NotifyConfigRequestVO;
import com.aizuda.easy.retry.server.web.model.request.UserSessionVO;
import com.aizuda.easy.retry.server.web.model.response.NotifyConfigResponseVO;
import com.aizuda.easy.retry.server.web.service.NotifyConfigService;
import com.aizuda.easy.retry.server.web.service.convert.NotifyConfigConverter;
import com.aizuda.easy.retry.server.web.service.convert.NotifyConfigResponseVOConverter;
import com.aizuda.easy.retry.server.web.util.UserSessionUtils;
import com.aizuda.easy.retry.template.datasource.access.AccessTemplate;
import com.aizuda.easy.retry.template.datasource.access.ConfigAccess;
import com.aizuda.easy.retry.template.datasource.persistence.po.NotifyConfig;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NotifyConfigServiceImpl
implements NotifyConfigService {
    @Autowired
    private AccessTemplate accessTemplate;

    @Override
    public PageResult<List<NotifyConfigResponseVO>> getNotifyConfigList(NotifyConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO();
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(NotifyConfig::getNamespaceId, (Object)userSessionVO.getNamespaceId());
        if (userSessionVO.isUser()) {
            queryWrapper.in(NotifyConfig::getGroupName, userSessionVO.getGroupNames());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getGroupName())) {
            queryWrapper.eq(NotifyConfig::getGroupName, (Object)queryVO.getGroupName());
        }
        if (StrUtil.isNotBlank((CharSequence)queryVO.getSceneName())) {
            queryWrapper.eq(NotifyConfig::getSceneName, (Object)queryVO.getSceneName());
        }
        queryWrapper.orderByDesc(NotifyConfig::getId);
        List notifyConfigs = this.accessTemplate.getNotifyConfigAccess().listPage(pageDTO, queryWrapper).getRecords();
        return new PageResult<List<NotifyConfigResponseVO>>(pageDTO, NotifyConfigResponseVOConverter.INSTANCE.batchConvert(notifyConfigs));
    }

    @Override
    public Boolean saveNotify(NotifyConfigRequestVO requestVO) {
        NotifyConfig notifyConfig = NotifyConfigConverter.INSTANCE.toNotifyConfig(requestVO);
        notifyConfig.setCreateDt(LocalDateTime.now());
        notifyConfig.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        ConfigAccess notifyConfigAccess = this.accessTemplate.getNotifyConfigAccess();
        Assert.isTrue((1 == notifyConfigAccess.insert((Object)notifyConfig) ? 1 : 0) != 0, () -> new EasyRetryServerException("failed to insert notify. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)notifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateNotify(NotifyConfigRequestVO requestVO) {
        Assert.notNull((Object)requestVO.getId(), () -> new EasyRetryServerException("\u53c2\u6570\u5f02\u5e38"));
        NotifyConfig notifyConfig = NotifyConfigConverter.INSTANCE.toNotifyConfig(requestVO);
        notifyConfig.setNamespaceId(null);
        Assert.isTrue((1 == this.accessTemplate.getNotifyConfigAccess().updateById((Object)notifyConfig) ? 1 : 0) != 0, () -> new EasyRetryServerException("failed to update notify. sceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)notifyConfig)}));
        return Boolean.TRUE;
    }

    @Override
    public NotifyConfigResponseVO getNotifyConfigDetail(Long id) {
        NotifyConfig notifyConfig = (NotifyConfig)this.accessTemplate.getNotifyConfigAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NotifyConfig::getId, (Object)id));
        return NotifyConfigResponseVOConverter.INSTANCE.convert(notifyConfig);
    }
}

