/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.model.enums;

import com.aizuda.easy.retry.server.web.model.response.DashboardLineResponseVO;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum DateTypeEnum {
    DAY(dashboardLineResponseVOList -> {
        Map<String, DashboardLineResponseVO> dashboardLineResponseVOMap = dashboardLineResponseVOList.stream().collect(Collectors.toMap(DashboardLineResponseVO::getCreateDt, i -> i));
        for (int i2 = 0; i2 <= LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).getHour(); ++i2) {
            String format = LocalDateTime.of(LocalDate.now(), LocalTime.MIN).plusHours(i2).format(DateTimeFormatter.ofPattern("HH"));
            DashboardLineResponseVO dashboardLineResponseVO = dashboardLineResponseVOMap.get(format);
            if (!Objects.isNull(dashboardLineResponseVO)) continue;
            dashboardLineResponseVO = new DashboardLineResponseVO().setTotal(0L).setTotalNum(0L).setFail(0L).setFailNum(0L).setMaxCountNum(0L).setRunningNum(0L).setSuccess(0L).setSuccessNum(0L).setSuspendNum(0L).setStop(0L).setCancel(0L).setCreateDt(format);
            dashboardLineResponseVOList.add(dashboardLineResponseVO);
        }
    }, startTime -> Objects.isNull(startTime) ? LocalDateTime.of(LocalDate.now(), LocalTime.MIN.withNano(0)) : LocalDateTime.of(startTime.toLocalDate(), LocalTime.MIN.withNano(0)), endTime -> Objects.isNull(endTime) ? LocalDateTime.of(LocalDate.now(), LocalTime.MAX.withNano(0)) : LocalDateTime.of(endTime.toLocalDate(), LocalTime.MAX.withNano(0))),
    WEEK(dashboardLineResponseVOList -> {
        Map<String, DashboardLineResponseVO> dispatchQuantityResponseVOMap = dashboardLineResponseVOList.stream().collect(Collectors.toMap(DashboardLineResponseVO::getCreateDt, i -> i));
        for (int i2 = 0; i2 < 7; ++i2) {
            String format = LocalDateTime.of(LocalDate.now().minusDays(i2), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            DashboardLineResponseVO dashboardLineResponseVO = dispatchQuantityResponseVOMap.get(format);
            if (!Objects.isNull(dashboardLineResponseVO)) continue;
            dashboardLineResponseVO = new DashboardLineResponseVO().setTotal(0L).setTotalNum(0L).setFail(0L).setFailNum(0L).setMaxCountNum(0L).setRunningNum(0L).setSuccess(0L).setSuccessNum(0L).setSuspendNum(0L).setStop(0L).setCancel(0L).setCreateDt(format);
            dashboardLineResponseVOList.add(dashboardLineResponseVO);
        }
    }, startTime -> Objects.isNull(startTime) ? LocalDateTime.of(LocalDate.now().minusDays(7L), LocalTime.MIN.withNano(0)) : LocalDateTime.of(startTime.toLocalDate().minusDays(7L), LocalTime.MIN.withNano(0)), endTime -> Objects.isNull(endTime) ? LocalDateTime.of(LocalDate.now(), LocalTime.MAX.withNano(0)) : LocalDateTime.of(endTime.toLocalDate(), LocalTime.MAX.withNano(0))),
    MONTH(dashboardLineResponseVOList -> {
        Map<String, DashboardLineResponseVO> dispatchQuantityResponseVOMap = dashboardLineResponseVOList.stream().collect(Collectors.toMap(DashboardLineResponseVO::getCreateDt, i -> i));
        for (int i2 = 0; i2 < LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).getDayOfMonth(); ++i2) {
            String format = LocalDateTime.of(LocalDate.now().minusDays(i2), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            DashboardLineResponseVO dashboardLineResponseVO = dispatchQuantityResponseVOMap.get(format);
            if (!Objects.isNull(dashboardLineResponseVO)) continue;
            dashboardLineResponseVO = new DashboardLineResponseVO().setTotal(0L).setTotalNum(0L).setFail(0L).setFailNum(0L).setMaxCountNum(0L).setRunningNum(0L).setSuccess(0L).setSuccessNum(0L).setSuspendNum(0L).setStop(0L).setCancel(0L).setCreateDt(format);
            dashboardLineResponseVOList.add(dashboardLineResponseVO);
        }
    }, startTime -> Objects.isNull(startTime) ? LocalDateTime.of(LocalDate.now().minusMonths(1L), LocalTime.MIN.withNano(0)) : LocalDateTime.of(startTime.toLocalDate().minusMonths(1L), LocalTime.MIN.withNano(0)), endTime -> Objects.isNull(endTime) ? LocalDateTime.of(LocalDate.now(), LocalTime.MAX.withNano(0)) : LocalDateTime.of(endTime.toLocalDate(), LocalTime.MAX.withNano(0))),
    YEAR(dashboardLineResponseVOList -> {
        Map<String, DashboardLineResponseVO> dispatchQuantityResponseVOMap = dashboardLineResponseVOList.stream().collect(Collectors.toMap(DashboardLineResponseVO::getCreateDt, i -> i));
        for (int i2 = 0; i2 < 12; ++i2) {
            String format = LocalDateTime.of(LocalDate.now().minusMonths(i2), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM"));
            DashboardLineResponseVO dashboardLineResponseVO = dispatchQuantityResponseVOMap.get(format);
            if (!Objects.isNull(dashboardLineResponseVO)) continue;
            dashboardLineResponseVO = new DashboardLineResponseVO().setTotal(0L).setTotalNum(0L).setFail(0L).setFailNum(0L).setMaxCountNum(0L).setRunningNum(0L).setSuccess(0L).setSuccessNum(0L).setSuspendNum(0L).setStop(0L).setCancel(0L).setCreateDt(format);
            dashboardLineResponseVOList.add(dashboardLineResponseVO);
        }
    }, startTime -> LocalDateTime.of(LocalDate.now().with(TemporalAdjusters.firstDayOfYear()), LocalTime.MIN.withNano(0)), endTime -> LocalDateTime.of(LocalDate.now().with(TemporalAdjusters.lastDayOfYear()), LocalTime.MAX.withNano(0))),
    OTHERS(dashboardLineResponseVOList -> {}, startTime -> LocalDateTime.of(startTime.toLocalDate(), LocalTime.MIN.withNano(0)), endTime -> LocalDateTime.of(endTime.toLocalDate(), LocalTime.MAX.withNano(0)));

    private Consumer<List<DashboardLineResponseVO>> consumer;
    private Function<LocalDateTime, LocalDateTime> startTime;
    private Function<LocalDateTime, LocalDateTime> endTime;

    private DateTypeEnum(Consumer<List<DashboardLineResponseVO>> listConsumer, Function<LocalDateTime, LocalDateTime> startTime, Function<LocalDateTime, LocalDateTime> endTime) {
        this.consumer = listConsumer;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Function<LocalDateTime, LocalDateTime> getStartTime() {
        return this.startTime;
    }

    public Function<LocalDateTime, LocalDateTime> getEndTime() {
        return this.endTime;
    }

    public Consumer<List<DashboardLineResponseVO>> getConsumer() {
        return this.consumer;
    }
}

