/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.controller;

import com.aizuda.easy.retry.server.web.annotation.LoginRequired;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.SceneConfigQueryVO;
import com.aizuda.easy.retry.server.web.model.request.SceneConfigRequestVO;
import com.aizuda.easy.retry.server.web.model.response.SceneConfigResponseVO;
import com.aizuda.easy.retry.server.web.service.SceneConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/scene-config"})
public class SceneConfigController {
    @Autowired
    private SceneConfigService sceneConfigService;

    @LoginRequired
    @GetMapping(value={"page/list"})
    public PageResult<List<SceneConfigResponseVO>> getSceneConfigPageList(SceneConfigQueryVO queryVO) {
        return this.sceneConfigService.getSceneConfigPageList(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"list"})
    public List<SceneConfigResponseVO> getSceneConfigList(@RequestParam(value="groupName") String groupName) {
        return this.sceneConfigService.getSceneConfigList(groupName);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public SceneConfigResponseVO getSceneConfigDetail(@PathVariable(value="id") Long id) {
        return this.sceneConfigService.getSceneConfigDetail(id);
    }

    @LoginRequired
    @PostMapping
    public Boolean saveSceneConfig(@RequestBody @Validated SceneConfigRequestVO requestVO) {
        return this.sceneConfigService.saveSceneConfig(requestVO);
    }

    @LoginRequired
    @PutMapping
    public Boolean updateSceneConfig(@RequestBody @Validated SceneConfigRequestVO requestVO) {
        return this.sceneConfigService.updateSceneConfig(requestVO);
    }
}

