/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.web.controller;

import com.aizuda.easy.retry.server.web.annotation.LoginRequired;
import com.aizuda.easy.retry.server.web.model.base.PageResult;
import com.aizuda.easy.retry.server.web.model.request.NotifyConfigQueryVO;
import com.aizuda.easy.retry.server.web.model.request.NotifyConfigRequestVO;
import com.aizuda.easy.retry.server.web.model.response.NotifyConfigResponseVO;
import com.aizuda.easy.retry.server.web.service.NotifyConfigService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/notify-config"})
public class NotifyConfigController {
    @Autowired
    private NotifyConfigService notifyConfigService;

    @LoginRequired
    @GetMapping(value={"list"})
    public PageResult<List<NotifyConfigResponseVO>> getNotifyConfigList(NotifyConfigQueryVO queryVO) {
        return this.notifyConfigService.getNotifyConfigList(queryVO);
    }

    @LoginRequired
    @GetMapping(value={"{id}"})
    public NotifyConfigResponseVO getNotifyConfigDetail(@PathVariable(value="id") Long id) {
        return this.notifyConfigService.getNotifyConfigDetail(id);
    }

    @LoginRequired
    @PostMapping
    public Boolean saveNotify(@RequestBody @Validated NotifyConfigRequestVO requestVO) {
        return this.notifyConfigService.saveNotify(requestVO);
    }

    @LoginRequired
    @PutMapping
    public Boolean updateNotify(@RequestBody @Validated NotifyConfigRequestVO requestVO) {
        return this.notifyConfigService.updateNotify(requestVO);
    }
}

