/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.generator.task;

import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.common.core.enums.JobTaskStatusEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskTypeEnum;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.dto.RegisterNodeInfo;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.util.ClientInfoUtils;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.generator.task.AbstractJobTaskGenerator;
import com.aizuda.easy.retry.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTask;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class BroadcastTaskGenerator
extends AbstractJobTaskGenerator {
    private static final Logger log = LoggerFactory.getLogger(BroadcastTaskGenerator.class);
    @Autowired
    private JobTaskMapper jobTaskMapper;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.BROADCAST;
    }

    @Override
    @Transactional
    public List<JobTask> doGenerate(JobTaskGenerateContext context) {
        Set serverNodes = CacheRegisterTable.getServerNodeSet((String)context.getGroupName(), (String)context.getNamespaceId());
        if (CollectionUtils.isEmpty((Collection)serverNodes)) {
            log.error("\u65e0\u53ef\u6267\u884c\u7684\u5ba2\u6237\u7aef\u4fe1\u606f. jobId:[{}]", (Object)context.getJobId());
            return Lists.newArrayList();
        }
        HashSet<String> clientInfoSet = new HashSet<String>(serverNodes.size());
        ArrayList<JobTask> jobTasks = new ArrayList<JobTask>(serverNodes.size());
        for (RegisterNodeInfo serverNode : serverNodes) {
            String address = serverNode.address();
            if (clientInfoSet.contains(address)) continue;
            JobTask jobTask = JobTaskConverter.INSTANCE.toJobTaskInstance(context);
            jobTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)serverNode));
            jobTask.setArgsType(context.getArgsType());
            jobTask.setArgsStr(context.getArgsStr());
            jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
            jobTask.setResultMessage(Optional.ofNullable(jobTask.getResultMessage()).orElse(""));
            Assert.isTrue((1 == this.jobTaskMapper.insert((Object)jobTask) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u65b0\u589e\u4efb\u52a1\u5b9e\u4f8b\u5931\u8d25"));
            clientInfoSet.add(address);
            jobTasks.add(jobTask);
        }
        return jobTasks;
    }
}

