/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.executor.workflow;

import akka.actor.ActorRef;
import com.aizuda.easy.retry.common.core.enums.JobOperationReasonEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskStatusEnum;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.common.core.enums.WorkflowNodeTypeEnum;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.akka.ActorGenerator;
import com.aizuda.easy.retry.server.common.dto.JobLogMetaDTO;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.dto.JobTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.executor.workflow.AbstractWorkflowExecutor;
import com.aizuda.easy.retry.server.job.task.support.executor.workflow.WorkflowExecutorContext;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTask;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTaskBatch;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Component
public class JobTaskWorkflowExecutor
extends AbstractWorkflowExecutor {
    @Override
    public WorkflowNodeTypeEnum getWorkflowNodeType() {
        return WorkflowNodeTypeEnum.JOB_TASK;
    }

    @Override
    protected boolean doPreValidate(WorkflowExecutorContext context) {
        return true;
    }

    @Override
    protected void afterExecute(WorkflowExecutorContext context) {
        if (Objects.equals(context.getWorkflowNodeStatus(), StatusEnum.YES.getStatus())) {
            return;
        }
        JobTaskBatch jobTaskBatch = this.generateJobTaskBatch(context);
        JobTask jobTask = this.generateJobTask(context, jobTaskBatch);
        JobLogMetaDTO jobLogMetaDTO = new JobLogMetaDTO();
        jobLogMetaDTO.setNamespaceId(context.getNamespaceId());
        jobLogMetaDTO.setGroupName(context.getGroupName());
        jobLogMetaDTO.setTaskBatchId(jobTaskBatch.getId());
        jobLogMetaDTO.setJobId(context.getJobId());
        jobLogMetaDTO.setTaskId(jobTask.getId());
        EasyRetryLog.REMOTE.warn("\u8282\u70b9[{}]\u5df2\u53d6\u6d88\u4efb\u52a1\u6267\u884c. \u53d6\u6d88\u539f\u56e0: \u4efb\u52a1\u5df2\u5173\u95ed. <|>{}<|>", new Object[]{context.getWorkflowNodeId(), jobLogMetaDTO});
    }

    @Override
    protected void beforeExecute(WorkflowExecutorContext context) {
    }

    @Override
    protected void doExecute(WorkflowExecutorContext context) {
        if (Objects.equals(context.getWorkflowNodeStatus(), StatusEnum.NO.getStatus())) {
            context.setTaskBatchStatus(JobTaskBatchStatusEnum.CANCEL.getStatus());
            context.setOperationReason(JobOperationReasonEnum.WORKFLOW_NODE_CLOSED_SKIP_EXECUTION.getReason());
            context.setJobTaskStatus(JobTaskStatusEnum.CANCEL.getStatus());
            this.workflowTaskExecutor(context);
        } else {
            JobTaskWorkflowExecutor.invokeJobTask(context);
        }
    }

    private static void invokeJobTask(WorkflowExecutorContext context) {
        JobTaskPrepareDTO jobTaskPrepare = JobTaskConverter.INSTANCE.toJobTaskPrepare(context.getJob(), context);
        jobTaskPrepare.setNextTriggerAt(DateUtils.toNowMilli() + DateUtils.toNowMilli() % 1000L);
        ActorRef actorRef = ActorGenerator.jobTaskPrepareActor();
        actorRef.tell((Object)jobTaskPrepare, actorRef);
    }
}

