/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.easy.retry.server.job.task.support.WorkflowPrePareHandler;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.WorkflowTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.WorkflowTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="WorkflowTaskPrepareActor")
@Scope(value="prototype")
public class WorkflowTaskPrepareActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(WorkflowTaskPrepareActor.class);
    private final List<WorkflowPrePareHandler> workflowPrePareHandlers;
    private final WorkflowTaskBatchMapper workflowTaskBatchMapper;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(WorkflowTaskPrepareDTO.class, workflowTaskPrepareDTO -> {
            try {
                this.doPrepare((WorkflowTaskPrepareDTO)workflowTaskPrepareDTO);
            }
            catch (Exception e) {
                log.error("\u9884\u5904\u7406\u8282\u70b9\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private void doPrepare(WorkflowTaskPrepareDTO workflowTaskPrepareDTO) {
        List workflowTaskBatches = this.workflowTaskBatchMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowTaskBatch::getWorkflowId, (Object)workflowTaskPrepareDTO.getWorkflowId())).in(WorkflowTaskBatch::getTaskBatchStatus, (Collection)JobTaskBatchStatusEnum.NOT_COMPLETE));
        if (CollectionUtils.isEmpty((Collection)workflowTaskBatches)) {
            for (WorkflowPrePareHandler workflowPrePareHandler : this.workflowPrePareHandlers) {
                if (!workflowPrePareHandler.matches(null)) continue;
                workflowPrePareHandler.handler(workflowTaskPrepareDTO);
            }
        } else {
            boolean onlyTimeoutCheck = false;
            for (WorkflowTaskBatch workflowTaskBatch : workflowTaskBatches) {
                workflowTaskPrepareDTO.setExecutionAt(workflowTaskBatch.getExecutionAt());
                workflowTaskPrepareDTO.setWorkflowTaskBatchId(workflowTaskBatch.getId());
                workflowTaskPrepareDTO.setOnlyTimeoutCheck(onlyTimeoutCheck);
                for (WorkflowPrePareHandler prePareHandler : this.workflowPrePareHandlers) {
                    if (!prePareHandler.matches(workflowTaskBatch.getTaskBatchStatus())) continue;
                    prePareHandler.handler(workflowTaskPrepareDTO);
                    break;
                }
                onlyTimeoutCheck = true;
            }
        }
    }

    public WorkflowTaskPrepareActor(List<WorkflowPrePareHandler> workflowPrePareHandlers, WorkflowTaskBatchMapper workflowTaskBatchMapper) {
        this.workflowPrePareHandlers = workflowPrePareHandlers;
        this.workflowTaskBatchMapper = workflowTaskBatchMapper;
    }
}

