/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.common.core.enums.JobTaskTypeEnum;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.job.task.dto.CompleteJobBatchDTO;
import com.aizuda.easy.retry.server.job.task.dto.JobExecutorResultDTO;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.JobTaskStopHandler;
import com.aizuda.easy.retry.server.job.task.support.handler.DistributedLockHandler;
import com.aizuda.easy.retry.server.job.task.support.handler.JobTaskBatchHandler;
import com.aizuda.easy.retry.server.job.task.support.stop.JobTaskStopFactory;
import com.aizuda.easy.retry.server.job.task.support.stop.TaskStopJobContext;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTask;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="JobExecutorResultActor")
@Scope(value="prototype")
public class JobExecutorResultActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(JobExecutorResultActor.class);
    private static final String KEY = "job_complete_{0}_{1}";
    @Autowired
    private JobTaskMapper jobTaskMapper;
    @Autowired
    private JobTaskBatchHandler jobTaskBatchHandler;
    @Autowired
    private DistributedLockHandler distributedLockHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(JobExecutorResultDTO.class, result -> {
            log.debug("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001. \u53c2\u6570:[{}]", (Object)JsonUtil.toJsonString((Object)result));
            try {
                JobTask jobTask = new JobTask();
                jobTask.setTaskStatus(result.getTaskStatus());
                if (Objects.nonNull(result.getResult())) {
                    jobTask.setResultMessage(JsonUtil.toJsonString((Object)result.getResult()));
                }
                Assert.isTrue((1 == this.jobTaskMapper.update((Object)jobTask, (Wrapper)new LambdaUpdateWrapper().eq(JobTask::getId, (Object)result.getTaskId())) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u66f4\u65b0\u4efb\u52a1\u5b9e\u4f8b\u5931\u8d25"));
                boolean tryCompleteAndStop = this.tryCompleteAndStop((JobExecutorResultDTO)result);
                if (!tryCompleteAndStop) {
                    this.distributedLockHandler.lockWithDisposableAndRetry(() -> this.tryCompleteAndStop((JobExecutorResultDTO)result), MessageFormat.format(KEY, result.getTaskBatchId(), result.getJobId()), Duration.ofSeconds(1L), Duration.ofSeconds(1L), 3);
                }
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error(" job executor result exception. [{}]", new Object[]{result, e});
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    private boolean tryCompleteAndStop(JobExecutorResultDTO result) {
        CompleteJobBatchDTO completeJobBatchDTO = JobTaskConverter.INSTANCE.toCompleteJobBatchDTO(result);
        boolean complete = this.jobTaskBatchHandler.complete(completeJobBatchDTO);
        if (complete && result.getTaskType().intValue() != JobTaskTypeEnum.CLUSTER.getType()) {
            JobTaskStopHandler instanceInterrupt = JobTaskStopFactory.getJobTaskStop(result.getTaskType());
            TaskStopJobContext stopJobContext = JobTaskConverter.INSTANCE.toStopJobContext(result);
            stopJobContext.setNeedUpdateTaskStatus(Boolean.FALSE);
            stopJobContext.setForceStop(Boolean.TRUE);
            instanceInterrupt.stop(stopJobContext);
        }
        return complete;
    }
}

