/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.dispatch;

import akka.actor.AbstractActor;
import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.common.core.context.SpringContext;
import com.aizuda.easy.retry.common.core.enums.JobOperationReasonEnum;
import com.aizuda.easy.retry.common.core.enums.JobTaskBatchStatusEnum;
import com.aizuda.easy.retry.common.core.enums.StatusEnum;
import com.aizuda.easy.retry.common.core.util.JsonUtil;
import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.WaitStrategy;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.dto.DistributeInstance;
import com.aizuda.easy.retry.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.easy.retry.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.strategy.WaitStrategies;
import com.aizuda.easy.retry.server.common.util.DateUtils;
import com.aizuda.easy.retry.server.job.task.dto.JobTimerTaskDTO;
import com.aizuda.easy.retry.server.job.task.dto.TaskExecuteDTO;
import com.aizuda.easy.retry.server.job.task.dto.WorkflowNodeTaskExecuteDTO;
import com.aizuda.easy.retry.server.job.task.support.JobExecutor;
import com.aizuda.easy.retry.server.job.task.support.JobTaskConverter;
import com.aizuda.easy.retry.server.job.task.support.cache.ResidentTaskCache;
import com.aizuda.easy.retry.server.job.task.support.event.JobTaskFailAlarmEvent;
import com.aizuda.easy.retry.server.job.task.support.executor.job.JobExecutorContext;
import com.aizuda.easy.retry.server.job.task.support.executor.job.JobExecutorFactory;
import com.aizuda.easy.retry.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.easy.retry.server.job.task.support.generator.task.JobTaskGenerator;
import com.aizuda.easy.retry.server.job.task.support.generator.task.JobTaskGeneratorFactory;
import com.aizuda.easy.retry.server.job.task.support.handler.WorkflowBatchHandler;
import com.aizuda.easy.retry.server.job.task.support.timer.JobTimerWheel;
import com.aizuda.easy.retry.server.job.task.support.timer.ResidentJobTimerTask;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.GroupConfigMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.JobTaskBatchMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.GroupConfig;
import com.aizuda.easy.retry.template.datasource.persistence.po.Job;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTask;
import com.aizuda.easy.retry.template.datasource.persistence.po.JobTaskBatch;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;

@Component(value="JobExecutorActor")
@Scope(value="prototype")
public class JobExecutorActor
extends AbstractActor {
    private static final Logger log = LoggerFactory.getLogger(JobExecutorActor.class);
    private final JobMapper jobMapper;
    private final JobTaskBatchMapper jobTaskBatchMapper;
    private final TransactionTemplate transactionTemplate;
    private final GroupConfigMapper groupConfigMapper;
    private final WorkflowBatchHandler workflowBatchHandler;

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().match(TaskExecuteDTO.class, taskExecute -> {
            try {
                log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1. [{}] [{}]", (Object)LocalDateTime.now(), (Object)JsonUtil.toJsonString((Object)taskExecute));
                this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult((TaskExecuteDTO)taskExecute){
                    final /* synthetic */ TaskExecuteDTO val$taskExecute;
                    {
                        this.val$taskExecute = taskExecuteDTO;
                    }

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        JobExecutorActor.this.doExecute(this.val$taskExecute);
                    }
                });
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error("job executor exception. [{}]", new Object[]{taskExecute, e});
                this.handlerTaskBatch((TaskExecuteDTO)taskExecute, JobTaskBatchStatusEnum.FAIL.getStatus(), JobOperationReasonEnum.TASK_EXECUTION_ERROR.getReason());
                SpringContext.getContext().publishEvent((ApplicationEvent)new JobTaskFailAlarmEvent(taskExecute.getTaskBatchId()));
            }
            finally {
                this.getContext().stop(this.getSelf());
            }
        }).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(TaskExecuteDTO taskExecute) {
        List<JobTask> taskList;
        Job job;
        block9: {
            block8: {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                if (JobTaskExecutorSceneEnum.AUTO_JOB.getType().equals(taskExecute.getTaskExecutorScene())) {
                    queryWrapper.eq(Job::getJobStatus, (Object)StatusEnum.YES.getStatus());
                }
                job = (Job)this.jobMapper.selectOne((Wrapper)queryWrapper.eq(Job::getId, (Object)taskExecute.getJobId()));
                try {
                    int taskStatus = JobTaskBatchStatusEnum.RUNNING.getStatus();
                    int operationReason = JobOperationReasonEnum.NONE.getReason();
                    if (Objects.isNull(job)) {
                        taskStatus = JobTaskBatchStatusEnum.CANCEL.getStatus();
                        operationReason = JobOperationReasonEnum.JOB_CLOSED.getReason();
                    } else if (CollectionUtils.isEmpty((Collection)CacheRegisterTable.getServerNodeSet((String)job.getGroupName(), (String)job.getNamespaceId()))) {
                        taskStatus = JobTaskBatchStatusEnum.CANCEL.getStatus();
                        operationReason = JobOperationReasonEnum.NOT_CLIENT.getReason();
                        WorkflowNodeTaskExecuteDTO taskExecuteDTO = new WorkflowNodeTaskExecuteDTO();
                        taskExecuteDTO.setWorkflowTaskBatchId(taskExecute.getWorkflowTaskBatchId());
                        taskExecuteDTO.setTaskExecutorScene(taskExecute.getTaskExecutorScene());
                        taskExecuteDTO.setParentId(taskExecute.getWorkflowNodeId());
                        taskExecuteDTO.setTaskBatchId(taskExecute.getTaskBatchId());
                        this.workflowBatchHandler.openNextNode(taskExecuteDTO);
                    }
                    this.handlerTaskBatch(taskExecute, taskStatus, operationReason);
                    if (taskStatus == JobTaskBatchStatusEnum.RUNNING.getStatus()) break block8;
                }
                catch (Throwable throwable) {
                    log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
                    TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){
                        final /* synthetic */ TaskExecuteDTO val$taskExecute;
                        final /* synthetic */ Job val$job;
                        {
                            this.val$taskExecute = taskExecuteDTO;
                            this.val$job = job;
                        }

                        public void afterCompletion(int status) {
                            JobTimerWheel.clearCache(SyetemTaskTypeEnum.JOB.getType(), this.val$taskExecute.getTaskBatchId());
                            JobExecutorActor.this.doHandlerResidentTask(this.val$job, this.val$taskExecute);
                        }
                    });
                    throw throwable;
                }
                log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
                return;
            }
            JobTaskGenerator taskInstance = JobTaskGeneratorFactory.getTaskInstance(job.getTaskType());
            JobTaskGenerateContext instanceGenerateContext = JobTaskConverter.INSTANCE.toJobTaskInstanceGenerateContext(job);
            instanceGenerateContext.setTaskBatchId(taskExecute.getTaskBatchId());
            taskList = taskInstance.generate(instanceGenerateContext);
            if (!CollectionUtils.isEmpty(taskList)) break block9;
            log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
            return;
        }
        JobExecutor jobExecutor = JobExecutorFactory.getJobExecutor(job.getTaskType());
        jobExecutor.execute(JobExecutorActor.buildJobExecutorContext(taskExecute, job, taskList));
        log.debug("\u51c6\u5907\u6267\u884c\u4efb\u52a1\u5b8c\u6210.[{}]", (Object)JsonUtil.toJsonString((Object)taskExecute));
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new /* invalid duplicate definition of identical inner class */);
    }

    @NotNull
    private static JobExecutorContext buildJobExecutorContext(TaskExecuteDTO taskExecute, Job job, List<JobTask> taskList) {
        JobExecutorContext context = JobTaskConverter.INSTANCE.toJobExecutorContext(job);
        context.setTaskList(taskList);
        context.setTaskBatchId(taskExecute.getTaskBatchId());
        context.setJobId(job.getId());
        context.setWorkflowTaskBatchId(taskExecute.getWorkflowTaskBatchId());
        context.setWorkflowNodeId(taskExecute.getWorkflowNodeId());
        return context;
    }

    private void handlerTaskBatch(TaskExecuteDTO taskExecute, int taskStatus, int operationReason) {
        JobTaskBatch jobTaskBatch = new JobTaskBatch();
        jobTaskBatch.setId(taskExecute.getTaskBatchId());
        jobTaskBatch.setExecutionAt(Long.valueOf(DateUtils.toNowMilli()));
        jobTaskBatch.setTaskBatchStatus(Integer.valueOf(taskStatus));
        jobTaskBatch.setOperationReason(Integer.valueOf(operationReason));
        Assert.isTrue((1 == this.jobTaskBatchMapper.updateById((Object)jobTaskBatch) ? 1 : 0) != 0, () -> new EasyRetryServerException("\u66f4\u65b0\u4efb\u52a1\u5931\u8d25"));
    }

    private void doHandlerResidentTask(Job job, TaskExecuteDTO taskExecuteDTO) {
        if (Objects.isNull(job) || JobTaskExecutorSceneEnum.MANUAL_JOB.getType().equals(taskExecuteDTO.getTaskExecutorScene()) || JobTaskExecutorSceneEnum.AUTO_WORKFLOW.getType().equals(taskExecuteDTO.getTaskExecutorScene()) || JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType().equals(taskExecuteDTO.getTaskExecutorScene()) || Objects.equals(StatusEnum.NO.getStatus(), job.getResident()) || !DistributeInstance.INSTANCE.getConsumerBucket().contains(job.getBucketIndex())) {
            return;
        }
        long count = this.groupConfigMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getNamespaceId, (Object)job.getNamespaceId())).eq(GroupConfig::getGroupName, (Object)job.getGroupName())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        if (count == 0L) {
            return;
        }
        JobTimerTaskDTO jobTimerTaskDTO = new JobTimerTaskDTO();
        jobTimerTaskDTO.setJobId(taskExecuteDTO.getJobId());
        jobTimerTaskDTO.setTaskBatchId(taskExecuteDTO.getTaskBatchId());
        jobTimerTaskDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.AUTO_JOB.getType());
        ResidentJobTimerTask timerTask = new ResidentJobTimerTask(jobTimerTaskDTO, job);
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)job.getTriggerType());
        Long preTriggerAt = ResidentTaskCache.get(job.getId());
        if (Objects.isNull(preTriggerAt) || preTriggerAt < job.getNextTriggerAt()) {
            preTriggerAt = job.getNextTriggerAt();
        }
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(job.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(preTriggerAt.longValue());
        Long nextTriggerAt = waitStrategy.computeTriggerTime(waitStrategyContext);
        long milliseconds = nextTriggerAt - preTriggerAt;
        log.debug("\u5e38\u9a7b\u4efb\u52a1\u76d1\u63a7. \u4efb\u52a1\u65f6\u95f4\u5dee:[{}] \u53d6\u4f59:[{}]", (Object)milliseconds, (Object)(DateUtils.toNowMilli() % 1000L));
        job.setNextTriggerAt(nextTriggerAt);
        JobTimerWheel.register(SyetemTaskTypeEnum.JOB.getType(), jobTimerTaskDTO.getTaskBatchId(), timerTask, milliseconds - DateUtils.toNowMilli() % 1000L, TimeUnit.MILLISECONDS);
        ResidentTaskCache.refresh(job.getId(), nextTriggerAt);
    }

    public JobExecutorActor(JobMapper jobMapper, JobTaskBatchMapper jobTaskBatchMapper, TransactionTemplate transactionTemplate, GroupConfigMapper groupConfigMapper, WorkflowBatchHandler workflowBatchHandler) {
        this.jobMapper = jobMapper;
        this.jobTaskBatchMapper = jobTaskBatchMapper;
        this.transactionTemplate = transactionTemplate;
        this.groupConfigMapper = groupConfigMapper;
        this.workflowBatchHandler = workflowBatchHandler;
    }
}

