/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.job.task.support.cache;

import com.aizuda.easy.retry.server.common.util.GraphUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.util.CollectionUtils;

public class MutableGraphCache {
    private static final Cache<Long, MutableGraph<Long>> cache = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    public static MutableGraph<Long> getOrDefault(Long workflowBatchId, String jsonGraph) {
        return Optional.ofNullable((MutableGraph)cache.getIfPresent((Object)workflowBatchId)).orElse(GraphUtils.deserializeJsonToGraph((String)jsonGraph));
    }

    public static MutableGraph<Long> get(Long workflowBatchId) {
        return MutableGraphCache.getOrDefault(workflowBatchId, "");
    }

    public static List<Long> getLeaves(Long workflowBatchId, String jsonGraph) {
        MutableGraph<Long> graph = MutableGraphCache.getOrDefault(workflowBatchId, jsonGraph);
        ArrayList leaves = Lists.newArrayList();
        for (Long node : graph.nodes()) {
            if (!CollectionUtils.isEmpty((Collection)graph.successors((Object)node))) continue;
            leaves.add(node);
        }
        return leaves;
    }

    public static Set<Long> getAllDescendants(MutableGraph<Long> graph, Long parentId) {
        HashSet<Long> descendants = new HashSet<Long>();
        MutableGraphCache.getAllDescendantsHelper(graph, parentId, descendants);
        return descendants;
    }

    public static Set<Long> getBrotherNode(MutableGraph<Long> graph, Long nodeId) {
        Set predecessors = graph.predecessors((Object)nodeId);
        if (CollectionUtils.isEmpty((Collection)predecessors)) {
            return Sets.newHashSet();
        }
        return graph.successors((Object)((Long)predecessors.stream().findFirst().get()));
    }

    private static void getAllDescendantsHelper(MutableGraph<Long> graph, Long parentId, Set<Long> descendants) {
        Set successors = graph.successors((Object)parentId);
        descendants.addAll(successors);
        for (Long successor : successors) {
            MutableGraphCache.getAllDescendantsHelper(graph, successor, descendants);
        }
    }
}

