/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.register;

import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.Register;
import com.aizuda.easy.retry.server.common.cache.CacheRegisterTable;
import com.aizuda.easy.retry.server.common.register.RegisterContext;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.ServerNodeMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.ServerNode;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;

public abstract class AbstractRegister
implements Register,
Lifecycle {
    private static final Logger log = LoggerFactory.getLogger(AbstractRegister.class);
    @Autowired
    protected ServerNodeMapper serverNodeMapper;

    @Override
    public boolean register(RegisterContext context) {
        this.beforeProcessor(context);
        ServerNode serverNode = this.initServerNode(context);
        boolean result = this.doRegister(context, serverNode);
        this.afterProcessor(serverNode);
        return result;
    }

    protected abstract void afterProcessor(ServerNode var1);

    protected void refreshExpireAt(List<ServerNode> serverNodes) {
        for (ServerNode serverNode : serverNodes) {
            serverNode.setExpireAt(this.getExpireAt());
        }
        if (serverNodes.size() != this.serverNodeMapper.batchUpdateExpireAt(serverNodes)) {
            try {
                this.serverNodeMapper.batchInsert(serverNodes);
            }
            catch (DuplicateKeyException duplicateKeyException) {
            }
            catch (Exception e) {
                EasyRetryLog.LOCAL.error("\u6ce8\u518c\u8282\u70b9\u5931\u8d25", new Object[]{e});
            }
        }
        for (ServerNode serverNode : serverNodes) {
            CacheRegisterTable.refreshExpireAt(serverNode);
        }
    }

    protected abstract void beforeProcessor(RegisterContext var1);

    protected ServerNode initServerNode(RegisterContext context) {
        ServerNode serverNode = new ServerNode();
        serverNode.setHostId(context.getHostId());
        serverNode.setHostIp(context.getHostIp());
        serverNode.setNamespaceId(context.getNamespaceId());
        serverNode.setGroupName(context.getGroupName());
        serverNode.setHostPort(context.getHostPort());
        serverNode.setNodeType(this.getNodeType());
        serverNode.setCreateDt(LocalDateTime.now());
        serverNode.setContextPath(context.getContextPath());
        serverNode.setExtAttrs(context.getExtAttrs());
        return serverNode;
    }

    protected abstract LocalDateTime getExpireAt();

    protected abstract boolean doRegister(RegisterContext var1, ServerNode var2);

    protected abstract Integer getNodeType();
}

