/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.lock.persistence;

import com.aizuda.easy.retry.common.log.EasyRetryLog;
import com.aizuda.easy.retry.server.common.Lifecycle;
import com.aizuda.easy.retry.server.common.cache.CacheLockRecord;
import com.aizuda.easy.retry.server.common.dto.LockConfig;
import com.aizuda.easy.retry.server.common.lock.persistence.LockStorage;
import com.aizuda.easy.retry.server.common.lock.persistence.LockStorageFactory;
import com.aizuda.easy.retry.server.common.register.ServerRegister;
import com.aizuda.easy.retry.template.datasource.enums.DbTypeEnum;
import com.aizuda.easy.retry.template.datasource.persistence.mapper.DistributedLockMapper;
import com.aizuda.easy.retry.template.datasource.persistence.po.DistributedLock;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.annotation.Order;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Component
@Order(value=-2147483648)
public class JdbcLockProvider
implements LockStorage,
Lifecycle {
    protected static final List<String> ALLOW_DB = Arrays.asList(DbTypeEnum.MYSQL.getDb(), DbTypeEnum.MARIADB.getDb(), DbTypeEnum.POSTGRES.getDb(), DbTypeEnum.ORACLE.getDb(), DbTypeEnum.SQLSERVER.getDb());
    private final DistributedLockMapper distributedLockMapper;
    private final PlatformTransactionManager platformTransactionManager;

    @Override
    public boolean supports(String storageMedium) {
        return ALLOW_DB.contains(storageMedium);
    }

    @Override
    public boolean createLock(LockConfig lockConfig) {
        return Boolean.TRUE.equals(this.notSupportedTransaction((TransactionCallback<Boolean>)((TransactionCallback)status -> {
            try {
                LocalDateTime now = lockConfig.getCreateDt();
                DistributedLock distributedLock = new DistributedLock();
                distributedLock.setName(lockConfig.getLockName());
                distributedLock.setLockedBy(ServerRegister.CURRENT_CID);
                distributedLock.setLockedAt(now);
                distributedLock.setLockUntil(lockConfig.getLockAtMost());
                distributedLock.setCreateDt(now);
                distributedLock.setUpdateDt(now);
                return this.distributedLockMapper.insert((Object)distributedLock) > 0;
            }
            catch (ConcurrencyFailureException | DuplicateKeyException | TransactionSystemException e) {
                return false;
            }
            catch (DataIntegrityViolationException | BadSqlGrammarException | UncategorizedSQLException e) {
                EasyRetryLog.LOCAL.error("Unexpected exception. lockName:[{}]", new Object[]{lockConfig.getLockName(), e});
                return false;
            }
        })));
    }

    @Override
    public boolean renewal(LockConfig lockConfig) {
        return Boolean.TRUE.equals(this.notSupportedTransaction((TransactionCallback<Boolean>)((TransactionCallback)status -> {
            LocalDateTime now = lockConfig.getCreateDt();
            DistributedLock distributedLock = new DistributedLock();
            distributedLock.setLockedBy(ServerRegister.CURRENT_CID);
            distributedLock.setLockedAt(now);
            distributedLock.setLockUntil(lockConfig.getLockAtMost());
            distributedLock.setName(lockConfig.getLockName());
            try {
                return this.distributedLockMapper.update((Object)distributedLock, (Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(DistributedLock::getName, (Object)lockConfig.getLockName())).le(DistributedLock::getLockUntil, (Object)now)) > 0;
            }
            catch (ConcurrencyFailureException | DataIntegrityViolationException | UncategorizedSQLException | TransactionSystemException e) {
                return false;
            }
        })));
    }

    @Override
    public boolean releaseLockWithDelete(String lockName) {
        return Boolean.TRUE.equals(this.notSupportedTransaction((TransactionCallback<Boolean>)((TransactionCallback)status -> {
            for (int i = 0; i < 10; ++i) {
                try {
                    Boolean bl = this.distributedLockMapper.delete((Wrapper)new LambdaUpdateWrapper().eq(DistributedLock::getName, (Object)lockName)) > 0;
                    return bl;
                }
                catch (Exception e) {
                    EasyRetryLog.LOCAL.error("unlock error. retrying attempt [{}] ", new Object[]{i, e});
                    continue;
                }
                finally {
                    CacheLockRecord.remove(lockName);
                }
            }
            return false;
        })));
    }

    @Override
    public boolean releaseLockWithUpdate(String lockName, LocalDateTime lockAtLeast) {
        LocalDateTime now = LocalDateTime.now();
        return Boolean.TRUE.equals(this.notSupportedTransaction((TransactionCallback<Boolean>)((TransactionCallback)status -> {
            for (int i = 0; i < 10; ++i) {
                try {
                    DistributedLock distributedLock = new DistributedLock();
                    distributedLock.setLockedBy(ServerRegister.CURRENT_CID);
                    distributedLock.setLockUntil(now.isBefore(lockAtLeast) ? lockAtLeast : now);
                    return this.distributedLockMapper.update((Object)distributedLock, (Wrapper)new LambdaUpdateWrapper().eq(DistributedLock::getName, (Object)lockName)) > 0;
                }
                catch (Exception e) {
                    EasyRetryLog.LOCAL.error("unlock error. retrying attempt [{}] ", new Object[]{i, e});
                    continue;
                }
            }
            return false;
        })));
    }

    @Override
    public void start() {
        LockStorageFactory.registerLockStorage(this);
    }

    @Override
    public void close() {
        this.distributedLockMapper.delete((Wrapper)new LambdaUpdateWrapper().eq(DistributedLock::getLockedBy, (Object)ServerRegister.CURRENT_CID));
    }

    private Boolean notSupportedTransaction(TransactionCallback<Boolean> action) {
        TransactionTemplate template = new TransactionTemplate(this.platformTransactionManager);
        template.setPropagationBehavior(4);
        return (Boolean)template.execute(action);
    }

    public JdbcLockProvider(DistributedLockMapper distributedLockMapper, PlatformTransactionManager platformTransactionManager) {
        this.distributedLockMapper = distributedLockMapper;
        this.platformTransactionManager = platformTransactionManager;
    }
}

