/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.easy.retry.server.common.lock;

import cn.hutool.core.lang.Assert;
import com.aizuda.easy.retry.server.common.cache.CacheLockRecord;
import com.aizuda.easy.retry.server.common.dto.LockConfig;
import com.aizuda.easy.retry.server.common.exception.EasyRetryServerException;
import com.aizuda.easy.retry.server.common.lock.LockManager;
import com.aizuda.easy.retry.server.common.lock.LockProvider;
import java.time.Duration;
import java.time.LocalDateTime;

public abstract class AbstractLockProvider
implements LockProvider {
    @Override
    public boolean lock(Duration lockAtMost) {
        return this.lock(lockAtMost, lockAtMost);
    }

    @Override
    public boolean lock(Duration lockAtLeast, Duration lockAtMost) {
        boolean tryToCreateLockRecord;
        LockConfig lockConfig = LockManager.getLockConfig();
        String lockName = lockConfig.getLockName();
        Assert.notNull((Object)lockAtMost, () -> new EasyRetryServerException("lockAtMost can not be null. lockName:[{}]", lockName));
        Assert.isFalse((boolean)lockAtMost.isNegative(), () -> new EasyRetryServerException("lockAtMost  is negative. lockName:[{}]", lockName));
        Assert.notNull((Object)lockAtLeast, () -> new EasyRetryServerException("lockAtLeast can not be null. lockName:[{}]", lockName));
        Assert.isFalse((lockAtLeast.compareTo(lockAtMost) > 0 ? 1 : 0) != 0, () -> new EasyRetryServerException("lockAtLeast is longer than lockAtMost for lock. lockName:[{}]", lockName));
        LockManager.setCreateDt(LocalDateTime.now());
        LockManager.setLockAtLeast(lockAtLeast);
        LockManager.setLockAtMost(lockAtMost);
        boolean bl = tryToCreateLockRecord = !CacheLockRecord.lockRecordRecentlyCreated(lockName);
        if (tryToCreateLockRecord && this.doLock(lockConfig)) {
            CacheLockRecord.addLockRecord(lockName);
            return true;
        }
        return this.doLockAfter(lockConfig);
    }

    protected abstract boolean doLockAfter(LockConfig var1);

    protected boolean doLock(LockConfig lockConfig) {
        return this.createLock(lockConfig);
    }

    @Override
    public void unlock() {
        try {
            LockConfig lockConfig = LockManager.getLockConfig();
            Assert.notNull((Object)lockConfig, () -> new EasyRetryServerException("lockConfig can not be null."));
            this.doUnlock(lockConfig);
        }
        finally {
            LockManager.clear();
        }
    }

    protected abstract void doUnlock(LockConfig var1);

    protected abstract boolean createLock(LockConfig var1);

    protected abstract boolean renewal(LockConfig var1);
}

